% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_with_counts.R
\name{rename_with_counts}
\alias{rename_with_counts}
\title{Adds the category count to each category name in a given variable column}
\usage{
rename_with_counts(d, variable_name)
}
\arguments{
\item{d}{a tibble or dataframe}

\item{variable_name}{the column with counts wanted}
}
\value{
a tibble with the counts appended to the `variable_name` column
}
\description{
`rename_with_counts` concatenates the count of each category to
  its category name given a specific variable. It can be useful in plots and
  tables to display the fequency of categories of a variable (see the example
  below).
}
\examples{
rename_with_counts(pima_diabetes, weight_class)

# Below is an example of how `rename_with_counts` can be helpful when
# creating plots and tables. This graph shows the outcomes of different
# weight classes in `pima_diabetes`. With the added information from
# `rename_with_counts`, we can see how common each category is.
library(ggplot2)
rename_with_counts(pima_diabetes, weight_class) \%>\%
  ggplot(aes(x = reorder(weight_class, diabetes, function(x) mean(x == "Y")),
             fill = diabetes)) +
  geom_bar(position = "fill") +
  coord_flip()

}
