% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmean-funcs.R
\name{hai_kmeans_obj}
\alias{hai_kmeans_obj}
\alias{kmeans_obj}
\title{K-Means Object}
\usage{
hai_kmeans_obj(.data, .centers = 5)

kmeans_obj(.data, .centers = 5)
}
\arguments{
\item{.data}{The data that gets passed from \code{\link[=hai_kmeans_user_item_tbl]{hai_kmeans_user_item_tbl()}}}

\item{.centers}{How many initial centers to start with}
}
\value{
A stats k-means object
}
\description{
Takes the output of the \code{\link[=hai_kmeans_user_item_tbl]{hai_kmeans_user_item_tbl()}} function and applies the
k-means algorithm to it using \code{\link[stats:kmeans]{stats::kmeans()}}
}
\details{
Uses the \code{\link[stats:kmeans]{stats::kmeans()}} function and creates a wrapper around it.
}
\examples{
library(healthyR.data)
library(dplyr)

data_tbl <- healthyR_data \%>\%
  filter(ip_op_flag == "I") \%>\%
  filter(payer_grouping != "Medicare B") \%>\%
  filter(payer_grouping != "?") \%>\%
  select(service_line, payer_grouping) \%>\%
  mutate(record = 1) \%>\%
  as_tibble()

hai_kmeans_user_item_tbl(
  .data = data_tbl,
  .row_input = service_line,
  .col_input = payer_grouping,
  .record_input = record
) \%>\%
  hai_kmeans_obj()

}
\seealso{
Other Kmeans: 
\code{\link{hai_kmeans_automl_predict}()},
\code{\link{hai_kmeans_automl}()},
\code{\link{hai_kmeans_mapped_tbl}()},
\code{\link{hai_kmeans_scree_data_tbl}()},
\code{\link{hai_kmeans_scree_plt}()},
\code{\link{hai_kmeans_tidy_tbl}()},
\code{\link{hai_kmeans_user_item_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Kmeans}
