% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hai-data-poly.R
\name{hai_data_poly}
\alias{hai_data_poly}
\title{Data Preprocessor - Polynomial Function}
\usage{
hai_data_poly(.recipe_object = NULL, ..., .p_degree = 2)
}
\arguments{
\item{.recipe_object}{The data that you want to process}

\item{...}{One or more selector functions to choose variables to be imputed.
When used with imp_vars, these dots indicate which variables are used to
predict the missing data in each variable. See selections() for more details}

\item{.p_degree}{The polynomial degree, an integer.}
}
\value{
A list object
}
\description{
Takes in a recipe and will scale values using a selected recipe. This function
is not exported but may be called via the ::: method.
}
\details{
This function will get your data ready for processing with many types of ml/ai
models.

This is intended to be used inside of the data processor and
therefore is an internal function. This documentation exists to explain the process
and help the user understand the parameters that can be set in the pre-processor function.

\code{\link[recipes:step_hyperbolic]{recipes::step_hyperbolic()}}
}
\examples{
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(recipes))

date_seq <- seq.Date(from = as.Date("2013-01-01"), length.out = 100, by = "month")
val_seq  <- rep(rnorm(10, mean = 6, sd = 2), times = 10)
df_tbl   <- tibble(
    date_col = date_seq,
    value    = val_seq
)

rec_obj <- recipe(value ~., df_tbl)

healthyR.ai:::hai_data_poly(
    .recipe_object = rec_obj,
    value
)$scale_rec_obj \%>\%
    get_juiced_data()

}
\seealso{
\url{https://recipes.tidymodels.org/reference/step_poly.html}

Other Data Recipes: 
\code{\link{hai_data_impute}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_transform}()},
\code{\link{hai_data_trig}()},
\code{\link{pca_your_recipe}()}

Other Preprocessor: 
\code{\link{hai_data_impute}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_transform}()},
\code{\link{hai_data_trig}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Data Recipes}
\concept{Preprocessor}
\keyword{internal}
