% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-model-compare.R
\name{ts_model_compare}
\alias{ts_model_compare}
\title{Compare Two Time Series Models}
\usage{
ts_model_compare(
  .model_1,
  .model_2,
  .type = "testing",
  .splits_obj,
  .data,
  .print_info = TRUE,
  .metric = "rmse"
)
}
\arguments{
\item{.model_1}{The model being compared to the base, this can also be a
hyperparameter tuned model.}

\item{.model_2}{The base model.}

\item{.type}{The default is the testing tibble, can be set to training as well.}

\item{.splits_obj}{The splits object}

\item{.data}{The original data that was passed to splits}

\item{.print_info}{This is a boolean, the default is TRUE}

\item{.metric}{This should be one of the following character strings:
\itemize{
\item "mae"
\item "mape"
\item "mase"
\item "smape"
\item "rmse"
\item "rsq"
}}
}
\value{
The function outputs a list invisibly.
}
\description{
This function will expect to take in two models that will be used for comparison.
It is useful to use this after appropriately following the modeltime workflow and
getting two models to compare. This is an extension of the calibrate and plot, but
it only takes two models and is most likely better suited to be used after running
a model through the \code{ts_model_auto_tune()} function to see the difference in performance
after a base model has been tuned.
}
\details{
This function expects to take two models. You must tell it if it will
be assessing the training or testing data, where the testing data is the default.
You must therefore supply the splits object to this function along with the origianl
dataset. You must also tell it which default modeltime accuracy metric should
be printed on the graph itself. You can also tell this function to print
information to the console or not. A static \code{ggplot2} polot and an interactive
\code{plotly} plot will be returned inside of the output list.
}
\examples{
\dontrun{
suppressPackageStartupMessages(library(healthyR.ts))
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(rsample))
suppressPackageStartupMessages(library(dplyr))

data_tbl <- ts_to_tbl(AirPassengers) \%>\%
  select(-index)

splits <- time_series_split(
  data       = data_tbl,
  date_var   = date_col,
  assess     = "12 months",
  cumulative = TRUE
)

rec_obj <- ts_auto_recipe(
 .data     = data_tbl,
 .date_col = date_col,
 .pred_col = value
)

wfs_mars <- ts_wfs_mars(.recipe_list = rec_obj)

wf_fits <- wfs_mars \%>\%
  modeltime_fit_workflowset(
    data = training(splits)
    , control = control_fit_workflowset(
         allow_par = FALSE
         , verbose = TRUE
       )
 )

calibration_tbl <- wf_fits \%>\%
    modeltime_calibrate(new_data = testing(splits))

base_mars <- calibration_tbl \%>\% pluck_modeltime_model(1)
date_mars <- calibration_tbl \%>\% pluck_modeltime_model(2)

ts_model_compare(
 .model_1    = base_mars,
 .model_2    = date_mars,
 .type       = "testing",
 .splits_obj = splits,
 .data       = data_tbl,
 .print_info = TRUE,
 .metric     = "rmse"
 )$plots$static_plot
}

}
\seealso{
Other Utility: 
\code{\link{calibrate_and_plot}()},
\code{\link{model_extraction_helper}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()},
\code{\link{ts_to_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
