% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_plots.R
\name{ts_qc_run_chart}
\alias{ts_qc_run_chart}
\title{Quality Control Run Chart}
\usage{
ts_qc_run_chart(
  .data,
  .date_col,
  .value_col,
  .interactive = FALSE,
  .median = TRUE,
  .cl = TRUE,
  .mcl = TRUE,
  .ucl = TRUE,
  .lc = FALSE,
  .lmcl = FALSE,
  .llcl = FALSE
)
}
\arguments{
\item{.data}{The data.frame/tibble to be passed.}

\item{.date_col}{The column holding the timestamp.}

\item{.value_col}{The column with the values to be analyzed.}

\item{.interactive}{Default is FALSE, TRUE for an interactive plotly plot.}

\item{.median}{Default is TRUE. This will show the median line of the data.}

\item{.cl}{This is the first upper control line}

\item{.mcl}{This is the second sigma control line positive}

\item{.ucl}{This is the third sigma control line positive}

\item{.lc}{This is the first negative control line}

\item{.lmcl}{This is the second sigma negative control line}

\item{.llcl}{This si the thrid sigma negative control line}
}
\value{
A static ggplot2 graph or if .interactive is set to TRUE a plotly plot
}
\description{
A control chart is a specific type of graph that shows data points between
upper and lower limits over a period of time. You can use it to understand
if the process is in control or not. These charts commonly have three types
of lines such as upper and lower specification limits, upper and lower limits
and planned value. By the help of these lines, Control Charts show the
process behavior over time.
}
\details{
\itemize{
\item Expects a time-series tibble/data.frame
\item Expects a date column and a value column
}
}
\examples{
library(dplyr)

data_tbl <- ts_to_tbl(AirPassengers) \%>\%
  select(-index)

data_tbl \%>\%
  ts_qc_run_chart(
    .date_col    = date_col
    , .value_col = value
    , .llcl      = TRUE
  )

}
\author{
Steven P. Sanderson II, MPH
}
