% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-tune-spec-template.R
\name{ts_model_spec_tune_template}
\alias{ts_model_spec_tune_template}
\title{Time Series Model Spec Template}
\usage{
ts_model_spec_tune_template(.parsnip_engine = NULL, .model_spec_class = NULL)
}
\arguments{
\item{.parsnip_engine}{The model engine that is used by \code{\link[parsnip:set_engine]{parsnip::set_engine()}}.}

\item{.model_spec_class}{The model spec class that is use by \code{parsnip}. For
example the 'kernlab' engine can use both \code{svm_poly} and \code{svm_rbf}.}
}
\value{
A tuneable parsnip model specification.
}
\description{
This function will create a generic tuneable model specification, this function
can be used by itself and is called internally by \code{\link[=ts_model_auto_tune]{ts_model_auto_tune()}}.
}
\details{
This function takes in a single parameter and uses that to output a generic
tuneable model specification. This function can work with the following
parsnip/modeltime engines:
\itemize{
\item "auto_arima"
\item "auto_arima_xgboost"
\item "ets"
\item "croston"
\item "theta"
\item "smooth_es"
\item "stlm_ets"
\item "tbats"
\item "stlm_arima"
\item "nnetar"
\item "prophet"
\item "prophet_xgboost"
\item "lm"
\item "glmnet"
\item "stan"
\item "spark"
\item "keras"
\item "earth"
\item "xgboost"
\item "kernlab"
}
}
\examples{
ts_model_spec_tune_template("ets")
ts_model_spec_tune_template("prophet")

}
\seealso{
Other Model Tuning: 
\code{\link{ts_model_auto_tune}()}

Other Utility: 
\code{\link{auto_stationarize}()},
\code{\link{calibrate_and_plot}()},
\code{\link{internal_ts_backward_event_tbl}()},
\code{\link{internal_ts_both_event_tbl}()},
\code{\link{internal_ts_forward_event_tbl}()},
\code{\link{model_extraction_helper}()},
\code{\link{ts_get_date_columns}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_is_date_class}()},
\code{\link{ts_lag_correlation}()},
\code{\link{ts_model_auto_tune}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()},
\code{\link{ts_to_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Helper}
\concept{Model Tuning}
\concept{Utility}
