% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-feature-cluster-plt.R
\name{ts_feature_cluster_plot}
\alias{ts_feature_cluster_plot}
\title{Time Series Feature Clustering}
\usage{
ts_feature_cluster_plot(
  .data,
  .date_col,
  .value_col,
  ...,
  .center = 3,
  .facet_ncol = 3,
  .smooth = FALSE
)
}
\arguments{
\item{.data}{The data passed must be the output of the \code{ts_feature_cluster()}
function.}

\item{.date_col}{The date column.}

\item{.value_col}{The column that holds the value of the time series that the
featurs were built from.}

\item{...}{This is where you can place grouping variables that are passed off
to \code{dplyr::group_by()}}

\item{.center}{An integer of the chosen amount of centers from the \code{ts_feature_cluster()}
function.}

\item{.facet_ncol}{This is passed to the \code{timetk::plot_time_series()} function.}

\item{.smooth}{This is passed to the \code{timetk::plot_time_series()} function and
is set to a default of FALSE.}
}
\value{
A list output
}
\description{
This function returns an output list of data and plots that
come from using the \code{K-Means} clustering algorithm on a time series data.
}
\details{
This function will return a list object output. The function itself
requires that the \code{ts_feature_cluster()} be passed to it as it will look for
a specific attribute internally.

The output of this function includes the following:

\strong{Data Section}
\itemize{
\item original_data
\item kmm_data_tbl
\item user_item_tbl
\item cluster_tbl
}

\strong{Plots}
\itemize{
\item static_plot
\item plotly_plot
}

\strong{K-Means Object}
\itemize{
\item k-means object
}
}
\examples{

library(dplyr)

data_tbl <- ts_to_tbl(AirPassengers) \%>\%
  mutate(group_id = rep(1:12, 12))

output <- ts_feature_cluster(
  .data = data_tbl,
  .date_col = date_col,
  .value_col = value,
  group_id,
  .features = c("acf_features","entropy"),
  .scale = TRUE,
  .prefix = "ts_",
  .centers = 3
)

ts_feature_cluster_plot(
  .data = output,
  .date_col = date_col,
  .value_col = value,
  .center = 2,
  group_id
)

}
\seealso{
Other Clustering: 
\code{\link{ts_feature_cluster}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Clustering}
