% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_tbl_functions.R
\name{named_item_list}
\alias{named_item_list}
\title{Tibble to named list}
\usage{
named_item_list(.data, .group_col)
}
\arguments{
\item{.data}{The data.frame/tibble.}

\item{.group_col}{The column that contains the groupings.}
}
\description{
Takes in a data.frame/tibble and creates a named list from a supplied grouping
variable. Can be used in conjunction with \code{\link[=save_to_excel]{save_to_excel()}} to create a new
sheet for each group of data.
}
\details{
\itemize{
\item Requires a data.frame/tibble and a grouping column.
}
}
\examples{
library(healthyR.data)

df <- healthyR_data
df_list <- named_item_list(.data = df, .group_col = service_line)
df_list

}
\author{
Steven P. Sanderson II, MPH
}
