% Generated by roxygen2 (4.0.1): do not edit by hand
\name{heatmap.compress}
\alias{heatmap.compress}
\title{Collapse a large data set for \code{heatmap.fit}}
\usage{
heatmap.compress(y, pred, init.grid)
}
\arguments{
\item{y}{A vector of observations of the dependent variable (in \{0,1\}).}

\item{pred}{A vector of predicted Pr(y = 1) corresponding to each element of \code{y}.}

\item{init.grid}{The number of bins on the interval [0, 1] to use for compression of \code{pred}.}
}
\value{
A list with the elements:
\item{y.out}{The value of \code{y}, 0 or 1.}
\item{pred.out}{The (binned) predicted Pr(y = 1) matching each observation.}
\item{weight.out}{A weight parameter indicating the proportion of observations in the bin; sums to one.}
\item{pred.total.out}{A vector of unique Pr(y = 1) bin values.}
\item{n.out}{The number of observations (non-empty bins) after the data are collapsed.}
\item{retained.obs}{A vector of indices for non-empty candidate bins (for internal use by \code{heatmap.fit}).}
}
\description{
Reduces the size of large binary data sets by binning them according to their predicted probability [0, 1].
}
\author{
Justin Esarey <justin@justinesarey.com>
}

