% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RColorBrewer.R
\name{RColorBrewer_colors}
\alias{RColorBrewer_colors}
\alias{BrBG}
\alias{PiYG}
\alias{PRGn}
\alias{PuOr}
\alias{RdBu}
\alias{RdGy}
\alias{RdYlBu}
\alias{RdYlGn}
\alias{Spectral}
\alias{Blues}
\alias{BuGn}
\alias{BuPu}
\alias{GnBu}
\alias{Greens}
\alias{Greys}
\alias{Oranges}
\alias{OrRd}
\alias{PuBu}
\alias{PuBuGn}
\alias{PuRd}
\alias{Purples}
\alias{RdPu}
\alias{Reds}
\alias{YlGn}
\alias{YlGnBu}
\alias{YlOrBr}
\alias{YlOrRd}
\alias{cool_warm}
\title{RColorBrewer color Ramp Palette}
\usage{
BrBG(n)

PiYG(n)

PRGn(n)

PuOr(n)

RdBu(n)

RdGy(n)

RdYlBu(n)

RdYlGn(n)

Spectral(n)

Blues(n)

BuGn(n)

BuPu(n)

GnBu(n)

Greens(n)

Greys(n)

Oranges(n)

OrRd(n)

PuBu(n)

PuBuGn(n)

PuRd(n)

Purples(n)

RdPu(n)

Reds(n)

YlGn(n)

YlGnBu(n)

YlOrBr(n)

YlOrRd(n)

cool_warm(n)
}
\arguments{
\item{n}{the number of colors (>= 1) to be in the palette.}
}
\value{
A character vector of color names.
}
\description{
Functions for getting the colors of RColorBrewer (i.e.: \link{brewer.pal}) without the limitation of only 9/11
color values, based on \link{colorRampPalette}.

For sequential palettes this is not essential since we have \link{viridis}. But for diverging palettes
this is quit essential.

The sequential palettes names are
Blues BuGn BuPu GnBu Greens Greys Oranges OrRd PuBu PuBuGn PuRd Purples RdPu Reds YlGn YlGnBu YlOrBr YlOrRd

The diverging palettes are
BrBG PiYG PRGn PuOr RdBu RdGy RdYlBu RdYlGn Spectral
And also cool_warm. The cool_warm palette is based on Kenneth Moreland's proposal (see ref).
It goes from blue (cool) to ref (warm), based on well thought-out design elements.
}
\examples{
\dontrun{

library(RColorBrewer)
display.brewer.all(n = 11, type = "div")
title(main = "Divergent color palette")
display.brewer.all(n = 9, type = c("seq"))
title(main = "Sequential color palette")



img <- function(obj, nam) {
  image(1:length(obj), 1, as.matrix(1:length(obj)),
    col = obj,
    main = nam, ylab = "", xaxt = "n", yaxt = "n", bty = "n"
  )
}

par(mfrow = c(10, 1))
img(rev(cool_warm(500)), "cool_warm, (Moreland 2009)")
img(RdBu(500), "RdBu")
img(BrBG(500), "BrBG")
img(PiYG(500), "PiYG")
img(PRGn(500), "PRGn")
img(PuOr(500), "PuOr")
img(RdGy(500), "RdGy")
img(RdYlBu(500), "RdYlBu")
img(RdYlGn(500), "RdYlGn")
img(Spectral(500), "Spectral")


library(heatmaply)
heatmaply(cor(mtcars), colors = PiYG, limits = c(-1, 1))
heatmaply(cor(mtcars), colors = RdBu, limits = c(-1, 1))
}
}
\references{
* Moreland, Kenneth. "Diverging color maps for scientific visualization." Advances in Visual Computing (2009): 92-103.
url: http://www.kennethmoreland.com/color-maps/
The code was provided here: http://stackoverflow.com/a/44073011/256662
Thanks to the user YAK, who relied on the code from the Rgnuplot package
(which is duplicated here, in order to save the need to import the entire package)
}
