% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_cusum.R
\name{dfr_cusum}
\alias{dfr_cusum}
\title{Cumulative Sum for Concept Drift Detection (CUMSUM) method}
\usage{
dfr_cusum(lambda = 100)
}
\arguments{
\item{lambda}{Necessary level for warning zone (2 standard deviation)}
}
\value{
\code{dfr_cusum} object
}
\description{
The cumulative sum (CUSUM) is a sequential analysis technique used for change detection.
}
\examples{
library(daltoolbox)
library(heimdall)

# This example uses an error-based drift detector with a synthetic a 
# model residual where 1 is an error and 0 is a correct prediction.

data(st_drift_examples)
data <- st_drift_examples$univariate
data$event <- NULL
data$prediction <- st_drift_examples$univariate$serie > 4

model <- dfr_cusum()

detection <- NULL
output <- list(obj=model, drift=FALSE)
for (i in 1:length(data$prediction)){
 output <- update_state(output$obj, data$prediction[i])
 if (output$drift){
   type <- 'drift'
   output$obj <- reset_state(output$obj)
 }else{
   type <- ''
 }
 detection <- rbind(detection, data.frame(idx=i, event=output$drift, type=type))
}

detection[detection$type == 'drift',]
}
