% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainScoringFunction.R
\name{score}
\alias{score}
\title{Calculate Healthy Eating Index (HEI) scores from NHANES data}
\usage{
score(
  scoringMethod,
  years,
  heiComponent,
  demographicGroup = NULL,
  sex = c("Female", "Male"),
  raceEthnicity = c("Asian", "White", "Black", "Other", "Mexican American",
    "Other Hispanic"),
  age = c(2, 100),
  familyIncome = c("[0, 5000)", "[5000, 10000)", "[10000, 15000)", "[15000, 20000)",
    "[20000, 25000)", "[25000, 35000)", "[35000, 45000)", "[45000, 55000)",
    "[55000, 65000)", "[65000, 75000)", "[75000, 100000)", "75000+", ">100000", ">20000",
    "<20000", "Refused", "Don't know", "NA")
)
}
\arguments{
\item{scoringMethod}{The HEI scoring method to use. Choose from "Simple," "Pop Ratio," or "Mean Ratio."}

\item{years}{The NHANES cycle to select, choose from: "0506," "0708," "0910," "1112," "1314," "1516," or "1718. etc.}

\item{heiComponent}{The HEI component to score and plot. Options include "Total Score", "Total Fruit", "Whole Fruits", "Total Vegetables", "Greens and Beans", "Whole Grains", "Total Dairy", "Total Protein", "Seafood and Plant Proteins", "Fatty Acids", "Refined Grains", "Sodium", "Added Sugars", and "Saturated Fat".}

\item{demographicGroup}{The demographic grouping by which the data should be scored. If scoringMethod = "Simple", choose NULL as the demographicGroup. Otherwise, choose from "Sex", "Race/Ethnicity", "Age", or "Family Income".}

\item{sex}{a vector of the sexes in desired subpopulation. Provide a vector with "Female", "Male", or both.}

\item{raceEthnicity}{a vector of races/ethnicities in desired subpopulation. Provide a vector including any combination of the following: "Asian", "White", "Black", "Other", "Mexican American", "Other Hispanic",}

\item{age}{a vector in the form c(min, max) with two numbers specifying the desired age range to analyze. Both numbers should either be ones (to represent the toddler age group including ages 12-23 months) or 2 and above.}

\item{familyIncome}{a vector of family income brackets in the desired subpopulation. Provide a vector including any combination of the following: "[0, 5000)","[5000, 10000)","[10000, 15000)","[15000, 20000)","[20000, 25000)","[25000, 35000)", "[35000, 45000)","[45000, 55000)","[55000, 65000)","[65000, 75000)","[75000, 100000)", "75000+",">100000", ">20000","<20000","Refused","Don't know", "NA"}
}
\value{
A tibble with HEI scores for the selected component for each individual (when scoringMethod = "Simple") or by demographic grouping specified in demographicGroup.
}
\description{
This function calculates HEI component or total scores using the inputted scoring method. The user can subset the data to only include subjects in specific demographic groups
}
\examples{
library(magrittr)
library(dplyr)
library(tibble)
library(rlang)
library(stats)
library(tidyr)

# Calculate the Total Fruit component score from the 2017-18 NHANES data
# using the 'Simple' method.
score(scoringMethod = "Simple",
                    years = "1718",
                    heiComponent = "Total Fruit",
                    demographicGroup = NULL)

# Calculate the total HEI score by sex using the population ratio method for
# White and Black individuals between ages 5 and 10 with a family income
# between 5000abd 15000 in the 2011-12 NHANES cycle.
score(scoringMethod = "Pop Ratio",
                    years = "1112",
                    heiComponent = "Total Score",
                    demographicGroup = "Sex",
                    raceEthnicity = c("White", "Black"),
                    age = c(5,10),
                    familyIncome = c("[5000, 10000)", "[10000, 15000)"))

}
