% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans_procedure.R
\name{kmeans_procedure}
\alias{kmeans_procedure}
\title{Kmeans procedure}
\usage{
kmeans_procedure(
  data,
  columns,
  threshold_min,
  threshold_max,
  verbose = FALSE,
  seed = 42
)
}
\arguments{
\item{data}{R data frame}

\item{columns}{vector of columns names of the data frame on which we perform the kmeans algorithm. These features have to be numeric.}

\item{threshold_min}{integer that represents the minimum size for cluster.}

\item{threshold_max}{integer that represents the maximum size fo cluster.}

\item{verbose}{boolean. if set to TRUE displays the current state of the procedure (by default set to FALSE).}

\item{seed}{integer that represents seed for the random call (if we want the output to be reproducible).}
}
\value{
a R data frame contains the number of observation in the original data frame and a column \code{cluster}
representing the cluster to which the observation belongs to.
}
\description{
This function allows to perform k-means clustering with constrained on the size of clusters
}
\examples{
data <- iris[, c(1:4)]
features <- colnames(iris)[c(1:4)]
result <- kmeans_procedure(data=data, columns=features, threshold_min=2, threshold=10,
verbose=FALSE, seed=10)
}
\references{
Link to the github package repository:
\url{https://www.github.com/Redcart/helda}
}
\author{
Simon CORDE
}
\keyword{cluster}
\keyword{kmeans}
\keyword{sizes}
