% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_end_to_fill.R
\name{start_end_to_fill}
\alias{start_end_to_fill}
\title{Function for filling start and end gaps in time series}
\usage{
start_end_to_fill(data, calendar, gap_variable, key_variable, time_variable)
}
\arguments{
\item{data}{R data frame}

\item{calendar}{R data frame complete empty calendar (as one can perform with \code{create_calendar_day})}

\item{gap_variable}{character that represents name of the variable we want to fill the start and end gaps}

\item{key_variable}{character that represents variable name that refers to the key variable in the panel data (ID, ...)}

\item{time_variable}{character that represents time variable name that permits to sort observation on a time scale}
}
\value{
a R data frame containing the original columns and a new one:
\itemize{
 \item \code{gap_variable}_corrected_1: the gap variable with starts and ends filled
 }
}
\description{
This function allows to fill the start and end gaps of a time series
by doing repetition of next (for the start) and previous values (for the end)
}
\examples{
rep(c("Paris", "Madrid", "Berlin"), each = 10)
jeu_donnees <- data.frame("country" = rep(c("France", "Spain", "Germany"), each = 10),
"capital" = rep(c("Paris", "Madrid", "Berlin"), each = 10),
"year" = 2009:2018,
"gdp" = c(NA, NA, 200, 300, 500, 1000, NA, NA, NA, 500,
 0, NA, NA, NA, NA, NA, NA, 800, 1200, 1500,
 100, 200, 400, 700, 700, 800, 600, 500, NA, NA))
 jeu_donnees <- na.omit(jeu_donnees)# we artificially create some gaps in the time series
 data_1 <- create_calendar(data = jeu_donnees, key_variable = "country", time_variable = "year",
 start_year = 2009, end_year = 2018)
 data_2 <- start_end_to_fill(data = jeu_donnees, calendar = data_1, gap_variable = "gdp",
 key_variable = "country", time_variable = "year")
 data_3 <- gap_to_fill(data = data_2, gap_variable = "gdp_corrected_1", key_variable = "country",
 time_variable = "year", digits = 1)
}
\references{
Link to the author's github package repository:
\url{https://www.github.com/Redcart/helda}
}
\author{
Simon CORDE
}
\keyword{fill}
\keyword{gaps}
\keyword{series}
\keyword{time}
