% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.boxM.R
\docType{data}
\name{plot.boxM}
\alias{plot.boxM}
\title{Plot for Box's M test and generalizations}
\usage{
\method{plot}{boxM}(
  x,
  gplabel = NULL,
  which = c("logDet", "product", "sum", "precision", "max"),
  log = which == "product",
  pch = c(16, 15),
  cex = c(2, 2.5),
  col = c("blue", "red"),
  rev = FALSE,
  xlim,
  conf = 0.95,
  method = 1,
  bias.adj = TRUE,
  lwd = 2,
  ...
)
}
\arguments{
\item{x}{A \code{"boxM"} object resulting from \code{\link{boxM}}}

\item{gplabel}{character string used to label the group factor.}

\item{which}{Measure to be plotted. The default, \code{"logDet"}, is the
standard plot.  Other values are: \code{"product"}, \code{"sum"},
\code{"precision"} and \code{"max"}}

\item{log}{logical; if \code{TRUE}, the log of the measure is plotted. The
default, \code{which=="product"}, produces a plot equivalent to the plot of
\code{"logDet"}.}

\item{pch}{a vector of two point symbols to use for the individual groups
and the pooled data, respectively}

\item{cex}{character size of point symbols, a vector of length two for
groups and pooled data, respectively}

\item{col}{colors for point symbols, a vector of length two for the groups
and the pooled data}

\item{rev}{logical; if \code{TRUE}, the order of the groups is reversed on
the vertical axis.}

\item{xlim}{x limits for the plot}

\item{conf}{coverage for approximate confidence intervals, \code{0 <= conf <
1} ; use \code{conf=0} to suppress these}

\item{method}{confidence interval method; see \code{\link{logdetCI}}}

\item{bias.adj}{confidence interval bias adjustment; see
\code{\link{logdetCI}}}

\item{lwd}{line width for confidence interval}

\item{...}{Arguments passed down to \code{\link[graphics]{dotchart}}.}
}
\description{
This function creates a simple dot chart showing the contributions (log
determinants) of the various groups to Box's M test for equality of
covariance matrices. An important virtue of these plots is that they can show
\emph{how} the groups differ from each other, and from the pooled
covariance matrix using a scalar like \eqn{ln | S |}. In this way, they
can suggest more specific questions or hypotheses regarding the
equality of covariance matrices, analogous to the use of contrasts
and linear hypotheses for testing differences among group mean vectors.

Because Box's M test is based on a specific function (log determinant) of
the covariance matrices in the groups compared to the pooled covariance
matrix, this function also also allow plots of other measures based on the
eigenvalues of these covariance matrices.

Confidence intervals are only available for the default Box M test, using
\code{which="logDet"}.
}
\examples{

# Iris data
res <- boxM(iris[, 1:4], iris[, "Species"])
plot(res, gplabel="Species")

# Skulls data
skulls.mod <- lm(cbind(mb, bh, bl, nh) ~ epoch, data=Skulls)
skulls.boxm <- boxM(skulls.mod)
plot(skulls.boxm, gplabel="Epoch")
plot(skulls.boxm, gplabel="Epoch", bias.adj=FALSE)

# other measures
 plot(skulls.boxm, which="product", gplabel="Epoch", xlim=c(10,14))
 plot(skulls.boxm, which="sum", gplabel="Epoch")
 plot(skulls.boxm, which="precision", gplabel="Epoch")
 plot(skulls.boxm, which="max", gplabel="Epoch")



}
\references{
Friendly, M., & Sigal, M. (2018). Visualizing Tests for Equality of Covariance Matrices. 
\emph{The American Statistician}, \bold{72}(4);
\doi{10.1080/00031305.2018.1497537}.
Online: \url{https://www.datavis.ca/papers/EqCov-TAS.pdf}.
}
\seealso{
\code{\link{boxM}}, \code{\link{logdetCI}}

\code{\link[graphics]{dotchart}}
}
\author{
Michael Friendly
}
\keyword{hgraph}
