% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incident.R
\name{incident}
\alias{incident}
\title{HERE Traffic API: Incidents}
\usage{
incident(aoi, from = NULL, to = NULL, url_only = FALSE)
}
\arguments{
\item{aoi}{\code{sf} object, Areas of Interest (POIs) of geometry type \code{POLYGON}.}

\item{from}{\code{POSIXct} object, start time of the earliest traffic incidents (\code{default = NULL}).}

\item{to}{\code{POSIXct} object, end time of the latest traffic incidents (\code{default = NULL}).}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object containing the traffic incidents.
}
\description{
Traffic incident information from the HERE 'Traffic' API in areas of
interest (AOIs). The incidents contain information about location, duration,
severity, type, description and further details.
}
\note{
The maximum width and height of the bounding box of the input AOIs is 1 degree.
This means that each polygon (= one row) in the AOI \code{sf} object should fit in a 1 x 1 degree bbox.
}
\examples{
# Provide an API Key for a HERE project
set_key("<YOUR API KEY>")

# Traffic incidents
incidents <- incident(
  aoi = aoi,
  url_only = TRUE
)
}
\references{
\href{https://developer.here.com/documentation/traffic-api/api-reference.html}{HERE Traffic API: Incidents}
}
