#' Example Points of Interest
#'
#' Some example Points of Interest (POIs):
#' Cities in Switzerland and Liechtenstein with more than 100'000 inhabitants.
#'
#' @docType data
#'
#' @usage data(poi)
#'
#' @format An object of class \code{"sf", "data.frame"}.
#'
#' @keywords datasets
#'
#' @source Made with Natural Earth. Free vector and raster map data \href{https://raw.githubusercontent.com/nvkelso/natural-earth-vector/master/geojson/ne_10m_populated_places_simple.geojson}{@naturalearthdata.com}
#'
#' @examples
#' data(poi)
"poi"

#' Example Areas of Interest
#'
#' Some example Areas of Interest (AOIs):
#' The boundary polygons of the districts of Zurich. The districts serve as the
#' basis for administrative tasks within the City of Zurich.
#'
#' @docType data
#'
#' @usage data(aoi)
#'
#' @format An object of class \code{"sf", "data.frame"}.
#'
#' @keywords datasets
#'
#' @source City of Zurich - Department of Civil Engineering and Waste Management - Geomatics + Surveying \href{https://www.geocat.ch/geonetwork/srv/api/records/64091dfe-2785-4b8d-ab01-4ae291c1054a}{@geocat.ch}
#'
#' @examples
#' data(aoi)
"aoi"
