% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hermite_function_sum_N}
\alias{hermite_function_sum_N}
\title{Convenience function to output the sum of orthonormal Hermite functions
 
 
The method calculates the sum of orthonormal Hermite functions, 
\eqn{\sum_{i} h_k(x_{i})} from \eqn{k=0,\dots,N} for the vector of values,
x.}
\usage{
hermite_function_sum_N(N, x, normalization_hermite = NULL)
}
\arguments{
\item{N}{An integer number.}

\item{x}{A numeric vector.}

\item{normalization_hermite}{A numeric vector of normalization factors 
generated by the hermite_normalization function.}
}
\value{
A numeric vector of length N+1.
}
\description{
Convenience function to output the sum of orthonormal Hermite functions
 
 
The method calculates the sum of orthonormal Hermite functions, 
\eqn{\sum_{i} h_k(x_{i})} from \eqn{k=0,\dots,N} for the vector of values,
x.
}
