% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hermite_normalization_N}
\alias{hermite_normalization_N}
\title{Convenience function to output Hermite normalization factors}
\usage{
hermite_normalization_N(N)
}
\arguments{
\item{N}{An integer number.}
}
\value{
A numeric vector of length N+1
}
\description{
The method returns numeric normalization factors that, when multiplied by 
the physicist Hermite polynomials times a Gaussian factor i.e.
\eqn{\exp{x^2/2}H_k(x)}, yields orthonormal Hermite functions \eqn{h_k(x)} 
for \eqn{k=0,\dots,N}.
}
\author{
Michael Stephanou <michael.stephanou@gmail.com>
}
