% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator.R
\name{quant}
\alias{quant}
\title{Estimates the quantiles at a vector of probability values}
\usage{
quant(h_est_obj, p, algorithm = "interpolate", accelerate_series = TRUE)
}
\arguments{
\item{h_est_obj}{A hermite_estimator_univar object.}

\item{p}{A numeric vector. A vector of probability values.}

\item{algorithm}{A string. Two possible values 'interpolate' which is faster
but may be less accurate or 'bisection' which is slower but potentially more
accurate.}

\item{accelerate_series}{A boolean value. If set to TRUE, the series 
acceleration methods described in:

Boyd, John P., and Dennis W. Moore. "Summability methods for 
Hermite functions." Dynamics of atmospheres and oceans 10.1 (1986): 51-62. 
 
are applied. If set to FALSE, then standard summation is applied.}
}
\value{
A numeric vector. The vector of quantile values associated with the
probabilities p.
}
\description{
This method utilizes the estimator (13) in paper Stephanou, Michael, 
Varughese, Melvin and Iain Macdonald. "Sequential quantiles via Hermite 
series density estimation." Electronic Journal of Statistics 11.1 (2017): 
570-607 <doi:10.1214/17-EJS1245>, with some modifications to improve the 
stability of numerical root finding when using the bisection algorithm. 
Note that this method is only applicable to the univariate Hermite 
estimator i.e. est_type = "univariate".
}
\details{
The object must be updated with observations prior to the use of this method.
}
\examples{
\dontrun{
hermite_est <- hermite_estimator(N = 10, standardize = TRUE, 
est_type="univariate", observations = rnorm(30))
quant_est <- quant(hermite_est, c(0.25, 0.5, 0.75))
}
}
