% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly2SpatialPolygons.R
\name{poly2SpatialPolygons}
\alias{poly2SpatialPolygons}
\title{Convert simple polygon to a \code{SpatialPolygons} object}
\usage{
poly2SpatialPolygons(x, ID = "border")
}
\arguments{
\item{x}{A list with components \code{x} and \code{y}.}

\item{ID}{The name of the resulting polygon.  Default is
\code{"border"}.}
}
\value{
A \code{\link[sp]{SpatialPolygons}} object
}
\description{
This function takes a simple polygon and attempts to
convert it to a \code{\link[sp]{SpatialPolygons}} object.
This list is assumed to have components \code{x} and
\code{y} that define the boundary of the polygon.
}
\examples{
angle = seq(0, 2 * pi, len = 100)
poly = list(x = cos(angle), y = sin(angle))
plot(poly, type = "l", asp = 1)
sppoly = poly2SpatialPolygons(poly)
library(sp)
plot(sppoly, axes = TRUE, asp = 1)
}
\author{
Joshua French
}
