% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-fits.R
\name{partsurvfit}
\alias{partsurvfit}
\title{Partitioned survival regression object}
\usage{
partsurvfit(object, data)
}
\arguments{
\item{object}{An object of class \code{\link{flexsurvreg_list}}.}

\item{data}{The data frame used to fit each survival model in \code{object}.
\code{\link{flexsurvreg}}.}
}
\value{
Returns an object of class "partsurvfit", which is a list containing two elements.
The first element, "models", contains the survival models passed to \code{object}, and the second
element, "data" contains the data frame passed to \code{data}.
}
\description{
Create a partitioned survival regression object of class "partsurvfit". The object contains a list
of fitted survival models fit using either \code{\link{flexsurvreg}} or \code{\link{flexsurvspline}} (i.e.,
an object of class \code{\link{flexsurvreg_list}}) and the data frame used to perform the fit of each model.
The same data frame must have been used for each fit.
}
\examples{
library("flexsurv")
fit1 <- flexsurv::flexsurvreg(formula = Surv(endpoint1_time, endpoint1_status) ~ age, 
                              data = psm4_exdata$survival,
                              dist = "weibull")
fit2 <- flexsurv::flexsurvreg(formula = Surv(endpoint2_time, endpoint2_status) ~ age, 
                              data = psm4_exdata$survival, 
                              dist = "weibull")
fsreg_list <- flexsurvreg_list(endpoint1 = fit1, endpoint2 = fit2)
fits <- partsurvfit(fsreg_list, data = psm4_exdata$survival)
class(fits)
}
\keyword{internal}
