% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summary.ce}
\alias{summary.ce}
\alias{format.summary.ce}
\title{Summary method for cost-effectiveness object}
\usage{
\method{summary}{ce}(object, prob = 0.95, labels = NULL, ...)

\method{format}{summary.ce}(
  x,
  digits_qalys = 2,
  digits_costs = 0,
  dr_qalys = NULL,
  dr_costs = NULL,
  pivot_from = "strategy",
  drop_grp = TRUE,
  pretty_names = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{\link{ce}} object.}

\item{prob}{A numeric scalar in the interval \verb{(0,1)} giving the confidence interval.
Default is 0.95 for a 95 percent interval.}

\item{labels}{A list of named vectors containing the values and labels of
variables. The elements of each vector are the values of a variable and the
names are the labels. The names of the list are the names of the variables.
See the output returned by \code{\link[=get_labels]{get_labels()}} for an example.}

\item{...}{Further arguments passed to or from other methods. Currently unused.}

\item{x}{A \code{summary.ce} object.}

\item{digits_qalys}{Number of digits to use to report QALYs.}

\item{digits_costs}{Number of digits to use to report costs.}

\item{dr_qalys}{Discount rate to subset to for quality-adjusted life-years (QALYs).}

\item{dr_costs}{Discount rate to subset to for costs.}

\item{pivot_from}{Character vector denoting a column or columns used to
"widen" the data. Should either be \code{"strategy"}, \code{"grp"}, \code{"outcome"},
or some combination of the three. There will be one column for each value of
the variables in \code{pivot_from}. Default is to widen so there is a column for each treatment
strategy. Set to \code{NULL} if you do not want to widen the table.}

\item{drop_grp}{If \code{TRUE}, then the group column will be removed if there is only
one subgroup; other it will be kept. If \code{FALSE}, then the \code{grp} column is never
removed.}

\item{pretty_names}{Logical. If \code{TRUE}, then the columns \code{strategy}, \code{grp},
\code{outcome}, \code{dr}, and \code{value} are renamed (if they exist) to \code{Strategy}, \code{Group},
\code{Outcome}, \verb{Discount rate}, and \code{Value}.}
}
\value{
\code{summary.ce()} returns an object of class \code{summary.ce} that is a tidy
\code{data.table} with the following columns:

\describe{
\item{dr}{The discount rate.}
\item{strategy}{The treatment strategy.}
\item{grp}{The patient subgroup.}
\item{type}{Either \code{"QALYs"} or \code{"Costs"}.}
\item{category}{Category is always \code{"QALYs"} when \code{type == "QALYs"}; otherwise,
it is the cost category.}
\item{estimate}{The point estimate computed as the average across the PSA samples.}
\item{lower}{The lower limit of the confidence interval.}
\item{upper}{The upper limit of the confidence interval.}
}

\code{format.summary.ce()} formats the table according to the arguments passed.
}
\description{
Summarize a \code{\link{ce}} object by producing confidence intervals for quality-adjusted
life-years (QALYs) and each cost category with \code{summary.ce()} and format for
pretty printing with \code{format.summary.ce()}.
}
\details{
For an example, see \code{\link{IndivCtstm}}.
}
