% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpmatrix.R
\name{expmat}
\alias{expmat}
\title{Matrix exponential}
\usage{
expmat(x, t = 1, ...)
}
\arguments{
\item{x}{An array of matrices.}

\item{t}{An optional scaling factor for \code{x}.}

\item{...}{Arguments to pass to \code{\link[msm:MatrixExp]{msm::MatrixExp()}}.}
}
\value{
Returns an array of exponentiated matrices. If \code{length(t) > 1}, then
\code{length(t)} arrays are returned for each element in \code{x}.
}
\description{
This is a wrapper around \code{\link[msm:MatrixExp]{msm::MatrixExp()}} that computes the exponential
of multiple square matrices.
}
\details{
This function is most useful when exponentiating transition intensity
matrices to produce transition probability matrices. To create transition
probability matrices for discrete time state transition models with annual
cycles, set \code{t=1}. An array of matrices is returned which can be used
to create the \code{value} element of a \code{\link{tparams_transprobs}} object. See
\code{\link[=qmatrix]{qmatrix()}} for an example.
}
\seealso{
\code{\link[=qmatrix.msm]{qmatrix.msm()}}, \code{\link[=qmatrix.data.table]{qmatrix.data.table()}}
}
