% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariance_functions.R
\name{cov_gen}
\alias{cov_gen}
\title{Correlation function of selected type, supporting both isotropic and product forms}
\usage{
cov_gen(X1, X2 = NULL, theta, type = c("Gaussian", "Matern5_2", "Matern3_2"))
}
\arguments{
\item{X1}{matrix of design locations, one point per row}

\item{X2}{matrix of design locations if correlation is calculated between \code{X1} and \code{X2} (otherwise calculated between \code{X1} and itself)}

\item{theta}{vector of lengthscale parameters (either of size one if isotropic or of size d if anisotropic)}

\item{type}{one of "\code{Gaussian}", "\code{Matern5_2}", "\code{Matern3_2}"}
}
\description{
Correlation function of selected type, supporting both isotropic and product forms
}
\details{
Definition of univariate correlation function and hyperparameters:
\itemize{
\item "\code{Gaussian}": \eqn{c(x, y) = exp(-(x-y)^2/theta)}
\item "\code{Matern5_2}": \eqn{c(x, y) = (1+sqrt(5)/theta * abs(x-y) + 5/(3*theta^2)(x-y)^2) * exp(-sqrt(5)*abs(x-y)/theta)}
\item "\code{Matern3_2}": \eqn{c(x, y) = (1+sqrt(3)/theta * abs(x-y)) * exp(-sqrt(3)*abs(x-y)/theta)}
}
Multivariate correlations are product of univariate ones.
}
