% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.hfr.R
\name{print.hfr}
\alias{print.hfr}
\title{Print an HFR model}
\usage{
\method{print}{hfr}(x, ...)
}
\arguments{
\item{x}{Fitted \code{hfr} model.}

\item{...}{additional methods passed to \code{print}.}
}
\value{
Summary statistics of HFR model
}
\description{
Print summary statistics for a fitted \code{hfr} model
}
\details{
The call that produced the object \code{x} is printed, following by a
\code{data.frame} of summary statistics, including the effective degrees of freedom
of the model, the R.squared and the regularization parameter.
}
\examples{
x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit = hfr(x, y, kappa = 0.5)
print(fit)

}
\seealso{
\code{hfr}, \code{predict}, \code{plot} and \code{coef} methods
}
\author{
Johann Pfitzinger
}
