% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se.avg.R
\name{se.avg}
\alias{se.avg}
\title{Calculate approximate standard errors for a fitted HFR model}
\usage{
se.avg(object)
}
\arguments{
\item{object}{Fitted \code{hfr} model.}
}
\value{
A vector of standard errors.
}
\description{
This function computes the weighted average standard errors across
levels using Burnham & Anderson (2004).
}
\details{
The HFR computes linear regressions over several levels of an estimated
hierarchy. By averaging the standard errors across hierarchical levels, an
indication can be obtained about the average significance of the variables.

Standard errors are understated, since the uncertainty in the hierarchy estimation
is not reflected.
}
\examples{
x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit = hfr(x, y, kappa = 0.5)
se.avg(fit)

}
\references{
Pfitzinger, J. (2022).
Cluster Regularization via a Hierarchical Feature Regression.
arXiv 2107.04831[statML]

Burnham, K. P. and Anderson, D. R. (2004).
Multimodel inference - understanding AIC and BIC in model selection.
Sociological Methods & Research 33(2): 261-304.
}
\seealso{
\code{\link{hfr}} method
}
\author{
Johann Pfitzinger
}
