\name{GCT.sim}
\alias{GCT.sim}
\title{Generalized component test simulator

}
\description{Performs the generalized component test from Gregory et al. (2014) on multiple data sets generated by \code{\link{build2popData}}.
}
\usage{
GCT.sim(DATA, r, smoother = "parzen", ntoorderminus = 2)
}

\arguments{
  \item{DATA}{an object returned by \code{\link{build2popData}} which is a list of \code{S} data sets.
	}
  \item{r}{the lag window size for variance estimation.
  	}
  \item{smoother}{the lag window used in the variance estimation.  Possible values are \code{"parzen"} and \code{"trapezoid"}.
  	}
  \item{ntoorderminus}{a value of \code{0,1}, or \code{2} such that the centering constant will retain terms of order \code{n^(-ntoorderminus)}.  Enter \code{0} for the moderate-p GCT, and enter \code{2} for the large-p GCT.  A value of \code{1} may be entered to retain only terms which are O(1/n), appropriate for a size of \code{p} between moderate and large.
  	} 
}
\value{ A data frame with columns
	\item{TSvalues}{the values of the unstudentized test statistic.
	}
	\item{pvalues}{the p-values.
	}
	\item{smoothtype}{the choice of the lag window used in variance estimation.
	}
	\item{T}{the values of the studentized test statistic.
	}
	\item{cent}{the values of the centering constant.
	}
	\item{var}{the values of the estimated variance of the test statistic.
	}
}
\references{
	Gregory, K., Carroll, R. J., Baladandayuthapani, V. and Lahiri, S. (2015). A two-sample test for equality of means in high dimension. 
		\emph{Journal of the American Statistician}, to appear
}
\author{
Karl Gregory   \email{kgregory@mail.uni-mannheim.de}, \url{http://www.stat.tamu.edu/~kbgregory}.
}

\seealso{
\code{\link{GCT.test}}
}
\examples{
	
\dontrun{

DATA <-build2popData(	
	n = 15,
	m = 20,
	p = 500,
	muX = rep(0,500),
	muY = rep(0,500),
	commoncov = FALSE,
	VarScaleY = 1,
	dep = "ARMA",
	ARMAparms = list(coefs=list(ma=c(.2,.3) , ar=c(.4,-.1))),
	LRparm = .75,
	S = 25,
	innov = function(n,...) rnorm(n,0,1),
	heteroscedastic=TRUE,
	het.diag = diag(.1 + rexp(500,1/2))
	)	
	
GCT.sim(DATA,r=20,smoother="parzen")

}
}

\keyword{htest}
\keyword{multivariate }
