% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlclassCox.R
\name{mlclassCox}
\alias{mlclassCox}
\title{Applications of machine learning in survival analysis by prognostic classification of genes by CoxPH model.}
\usage{
mlclassCox(m, n, idSurv, idEvent, Time, s_ID, per = 20, fold = 3, data)
}
\arguments{
\item{m}{Starting column number from where high dimensional variates to be selected.}

\item{n}{Ending column number till where high dimensional variates to be selected.}

\item{idSurv}{"Column/Variable name" consisting duration of survival.}

\item{idEvent}{"Column/Variable name" consisting survival event.}

\item{Time}{"Column/Variable name" consisting Times of repeated observations.}

\item{s_ID}{"Column/Variable name" consisting unique identification for each subject.}

\item{per}{Percentage value for ordering, default=20.}

\item{fold}{Number of folds for re-sampling, default=3.}

\item{data}{High dimensional data containing survival observations with multiple covariates.}
}
\value{
A list of genes as per their classifications
\describe{
  \item{GeneClassification}{List of genes classified using Cox proportional hazard model}
  \item{GeneClassification$Positive_Gene}{Sublist of genes classified as positive genes}
  \item{GeneClassification$Negative_Gene}{Sublist of genes classified as negative genes}
  \item{GeneClassification$Volatile_Gene}{Sublist of genes classified as volatile genes}
  \item{Result}{A dataframe consisting threshold values with corresponding coefficients and p-values.}
}
}
\description{
Applications of machine learning in survival analysis by prognostic classification of genes by CoxPH model.
}
\examples{
\donttest{
data(srdata)
mlclassCox(m=50,n=59,idSurv="OS",idEvent="event",Time="Visit",s_ID="ID",per=20,fold=3,data=srdata)
}
}
