% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc-hc_add_series-deprecated.R
\name{hc_add_series_df}
\alias{hc_add_series_df}
\title{Shortcut  for tidy data frame a la ggplot2/qplot}
\usage{
hc_add_series_df(hc, data, type = NULL, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{data}{A \code{data.frame} object.}

\item{type}{The type of chart. Possible values are line, scatter, point, column,
columnnrange, etc. See \url{http://api.highcharts.com/highcharts#series}.}

\item{...}{Aesthetic mappings, \code{x y group color low high}.}
}
\description{
Function to create chart from tidy data frames. As same as qplot
you can use aesthetic including the group variable
}
\details{
The types supported are line, columnn, point, polygon,
columnrange, spline, areaspline among others.

Automatically parsed de data frame (to a list o series). You
you can use the  default parameters of highcharts such as \code{x}, \code{y},
\code{z}, \code{color}, \code{name}, \code{low}, \code{high} for
each series, for example check
\url{http://api.highcharts.com/highcharts#series<bubble>.data}.
}
\examples{

\dontrun{
require("dplyr")
n <- 50
df <- data_frame(
  x = rnorm(n),
  y = x * 2 + rnorm(n),
  w =  x^2
  )
  
hc_add_series_df(highchart(), data = df, type = "point", x = x, y = y)
hc_add_series_df(highchart(), data = df, type = "point", color = w)
hc_add_series_df(highchart(), data = df, type = "point", color = w, size = y)

m <- 50
s <- cumsum(rnorm(m))
e <- 2 + rbeta(m, 2, 2)

df2 <- data_frame(
  var = seq(m),
  l = s - e,
  h = s + e,
  n = paste("I'm point ", var)
)

hc_add_series_df(highchart(), data = df2, type = "columnnrange",
                 x = var, low = l, high = h, name = n, color = var)

hc_add_series_df(highchart(), iris, "point",
                      x = Sepal.Length, y = Sepal.Width, group = Species)

  
data(mpg, package = "ggplot2")

# point and scatter is the same
hc_add_series_df(highchart(), mpg, "scatter", x = displ, y = cty)
hc_add_series_df(highchart(), mpg, "point", x = displ, y = cty,
                      group = manufacturer)
     

mpgman <- count(mpg, manufacturer)
hc_add_series_df(highchart(), mpgman, "columnn", x = manufacturer, y = n) \%>\% 
  hc_xAxis(type = "category")

mpgman2 <- count(mpg, manufacturer, year)
hc_add_series_df(highchart(), mpgman2, "bar", x = manufacturer, y = n, group = year) \%>\% 
  hc_xAxis(type = "category")
  
data(economics, package = "ggplot2")

hc_add_series_df(highchart(), economics, "line", x = date, y = unemploy) \%>\% 
  hc_xAxis(type = "datetime")

data(economics_long, package = "ggplot2")

economics_long2 <- filter(economics_long,
                          variable \%in\% c("pop", "uempmed", "unemploy"))
                          
hc_add_series_df(highchart(), economics_long2, "line", x = date,
                 y = value01, group = variable) \%>\% 
  hc_xAxis(type = "datetime")

}

}
