% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{exchangeHoursOnly}
\alias{exchangeHoursOnly}
\title{Extract data from an \code{xts} object for the exchange hours only}
\usage{
exchangeHoursOnly(
  data,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  tz = NULL
)
}
\arguments{
\item{data}{a \code{data.table} or \code{xts} object containing the time series data. 
Multiple days of input are allowed.}

\item{marketOpen}{character in the format of \code{"HH:MM:SS"},
specifying the opening time of the exchange(s).}

\item{marketClose}{character in the format of \code{"HH:MM:SS"},
specifying the closing time of the exchange(s).}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. We attempt to extract the timezone from the DT column of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}}
}
\value{
\code{xts} or \code{data.table} object depending on input.
}
\description{
Filter raw trade data such and return only data between market close and market open. 
By default, \code{marketOpen = "09:30:00"} and \code{marketClose = "16:00:00"} (see Brownlees and Gallo (2006) for more information on good choices for these arguments).
}
\examples{
exchangeHoursOnly(sampleTDataRaw)
}
\references{
Brownlees, C. T. and Gallo, G. M. (2006). Financial econometric analysis at ultra-high frequency: Data handling concerns. Computational Statistics & Data Analysis, 51, pages 2232-2245.
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{cleaning}
