% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highs.R
\name{highs_solver}
\alias{highs_solver}
\title{Highs Solver}
\usage{
highs_solver(model, control = highs_control())
}
\arguments{
\item{model}{an object of class \code{"highs_model"} created with \code{highs_model()}.}

\item{control}{an object of class \code{"highs_control"} created with \code{highs_control()}.}
}
\value{
an object of class \code{"highs_solver"}.
}
\description{
Create a wrapper around the \code{HiGHS} solver. Manly usefull if one wants
a low level wrapper around highs with hot-start capabilities. \cr
}
\details{
\strong{Methods} \cr
The following methods are provided by the \code{"highs_solver"} class.
\itemize{
   \item \code{solve(...)} method to be called to solve the optimization problem.
         Returns an integer giving the status code returned by \strong{HiGHS}.
   \item \code{status()} method to obtain the status from the solver.
   \item \code{status_message()} method to obtain the status message from the solver.
   \item \code{solution()} method to obtain the solution from the solver.
   \item \code{info()} info to obtain addtional information from the solver.
   \item \code{L(i, v)} method to get and set the linear part of the objective.
   \item \code{A(i, j, v)} method to get and set the constraint matrix coefficients.
   \item \code{cbounds(i, lhs, rhs)} method to get and set the constraint bounds
                                     (left hand-side and right hand-side).
   \item \code{types(i, v)} method to get and set the variable types.
   \item \code{vbounds(i, lower, upper)} method to get and set the variable bounds.
   \item \code{maximum(maximize)} method to get and set the sense of the problem.
}
\strong{Method arguments} \cr
\itemize{
   \item \code{...} optional control arguments, which can be used to alter the options
                    set via the \code{control} argument when initializing the solver.
   \item \code{i} a vector of integers giving the index (vector index or row index)
                  of the coeficcients to be altered.
   \item \code{j} a vector of integers giving the index (column index) of the coeficcients to be altered.
   \item \code{v} a vector of doubles giving the values of the coeficcients to be altered.
   \item \code{lhs} a vector of doubles giving left hand-side.
   \item \code{rhs} a vector of doubles giving right hand-side.
   \item \code{lower} a vector of doubles giving the lower bounds to be altered.
   \item \code{upper} a vector of doubles giving the upper bounds to be altered.
}
}
\examples{
A <- rbind(c(0, 1), c(1, 2), c(3, 2))
m <- highs_model(L = c(1.0, 1), lower = c(0, 1), upper = c(4, Inf),
                 A = A, lhs = c(-Inf, 5, 6), rhs = c(7, 15, Inf),
                 offset = 3)
solver <- highs_solver(m)

}
