% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hight_dec.R
\name{hight_dec}
\alias{hight_dec}
\title{Perform decryption using HIGHT.}
\usage{
hight_dec(C, IV, MK, mode, output = "int")
}
\arguments{
\item{C}{Encrypted plaintext by HIGHT.}

\item{IV}{Initialization Vector. The IV is usually generated randomly and is different for each encryption operation. It is combined with the encryption key to produce a unique key for each encryption operation. Its length must be equal to 8, which is a unit of cryptographic block, and the value range must also have a value from 0 to 255.}

\item{MK}{Master Key. This is used to encrypt other keys that are used to encrypt and decrypt data. This should be typically kept secret and is only accessible to authorized users who need to use it for encryption and decryption operations. It should have a length of 16 and must have a value from 0 to 255.}

\item{mode}{Please select one from 'ecb'(Electric CodeBook mode),'cfb'(Cipher FeedBack mode),'cbc'(Cipher Block Chaining mode),'ofb'(Output FeedBack mode).}

\item{output}{Support 'hex'(e.g. '0x66') string or 'int'(e.g. 102) for output format.}
}
\value{
Returns a numeric vector decrypted by the HIGHT algorithm.
}
\description{
HIGHT (HIGh security and light weigHT) is a symmetric key block cipher algorithm designed for use in resource-constrained environments such as embedded systems and wireless sensor networks.
Outputs 64-bit ciphertext from 128-bit master key and 64-bit plaintext. This process can be repeated multiple times.
}
\examples{
MK = c(0x88, 0xE3, 0x4F, 0x8F, 0x08, 0x17, 0x79, 0xF1,
       0xE9, 0xF3, 0x94, 0x37, 0x0A, 0xD4, 0x05, 0x89)
IV = c(0x26, 0x8D, 0x66, 0xA7, 0x35, 0xA8, 0x1A, 0x81)
P = c(0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07)
C = hight_enc(P,IV,MK,mode = 'cbc', output='int')
hight_dec (C, IV, MK , mode = 'cbc', output = 'int')

}
\references{
Hong, D., Sung, J., Hong, S., Lim, J., Lee, S., Koo, B. S., ... & Chee, S. (2006). HIGHT: A new block cipher suitable for low-resource device. In Cryptographic Hardware and Embedded Systems-CHES 2006: 8th International Workshop, Yokohama, Japan, October 10-13, 2006. Proceedings 8 (pp. 46-59). Springer Berlin Heidelberg.
}
