% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_specs.R
\name{hip_fwf_positions}
\alias{hip_fwf_positions}
\alias{hip_fwf_widths}
\title{Specify column-specific options for hipread}
\usage{
hip_fwf_positions(start, end, col_names, col_types, trim_ws = TRUE,
  imp_dec = 0)

hip_fwf_widths(widths, col_names, col_types, trim_ws = TRUE, imp_dec = 0)
}
\arguments{
\item{start, end}{A vector integers describing the start and end positions
of each field}

\item{col_names}{A character vector of variable names}

\item{col_types}{A vector of column types (specified as either
"c" or "character" for character, "d" or "double" for double and
"i" or "integer" for integer).}

\item{trim_ws}{A logical vector, indicating whether to trim whitespace
on both sides of character columns (Defaults to \code{TRUE}, ignored on
non-character columns).}

\item{imp_dec}{An integer vector, indicating the number of implicit decimals
on a double variable (Defaults to 0, ignored on non-double columns).}

\item{widths}{A vector of integer widths for each field (assumes that
columns are consecutive - that there is no overlap or gap between fields)}
}
\value{
A data.frame containing the column specifications
}
\description{
Specify column specifications analogous to \code{readr::fwf_positions()}.
However, unlike in readr, the column type information is specified
alongside the column positions and there are two extra options that
can be specified (\code{trim_ws} gives control over trimming whitespace
in character columns, and \code{imp_dec} allows for implicit decimals in
double columns).
}
\examples{
# 3 Columns, specified by position
hip_fwf_positions(
  c(1, 3, 7),
  c(2, 6, 10),
  c("Var1", "Var2", "Var3"),
  c("c", "i", "d")
)

# The same 3 columns, specified by width
hip_fwf_widths(
  c(2, 4, 4),
  c("Var1", "Var2", "Var3"),
  c("c", "i", "d")
)

}
