% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.extrapol.R
\name{posterior.extrapol}
\alias{posterior.extrapol}
\title{Spatial extrapolation with the HKEVP.}
\usage{
posterior.extrapol(fit, targets, targets.covariates, sites.covariates)
}
\arguments{
\item{fit}{A named list.
Output from the \code{hkevp.fit} procedure.}

\item{targets}{A matrix of real values.
Coordinates of the sites where the marginal GEV distribution should be extrapolated. Each row corresponds to a target position and each column to a coordinate.}

\item{targets.covariates}{A matrix of real values.
Spatial covariates associated with each target. Each row corresponds to a target and each column to a spatial covariate. By default, only the intercept and the target coordinates are used. An error occurs if number of targets covariates and sites covariates do not match.}

\item{sites.covariates}{A matrix of real values.
Spatial covariates associated to the sites. Each row corresponds to a site and each column to a spatial covariate. By default, only the intercept and the target coordinates are used. An error occurs if number of targets covariates and sites covariates do not match.}
}
\value{
A named list with three elements: \code{mu}, \code{sigma}, \code{xi}, each one corresponding to a GEV parameter. Each element is a matrix where each column corresponds to a position and each row to a state of the Markov chain.
}
\description{
Extrapolation of the marginal GEV distribution at a set of ungauged sites (targets), given the results from the MCMC procedure \code{hkevp.fit}. See details.
}
\details{
Spatial extrapolation of the GEV distribution at target positions \eqn{(s^*_1, ..., s^*_k)} is performed with a simple kriging procedure at each MCMC step on the spatial processes associated to the GEV parameters.

Note that if you have furnished the spatial covariates as arguments in the function \code{hkevp.fit}, they should have been standardized.
}
\examples{
# Simulation of HKEVP:
sites <- as.matrix(expand.grid(1:3,1:3))
knots <- sites
mu <- sites[,1]*10
sigma <- 3
xi <- .2
alpha <- .4
tau <- 1
ysim <- hkevp.rand(10, sites, knots, mu, sigma, xi, alpha, tau)

# HKEVP fit:
fit <- hkevp.fit(ysim, sites, knots, niter = 100, nburn = 50, quiet = FALSE)

## Extrapolation:
targets <- matrix(1.5, 1, 2)
gev.targets <- posterior.extrapol(fit, targets)

## True vs predicted:
predicted <- sapply(gev.targets, median)
sd.predict <- sapply(gev.targets, sd)
true <- c(targets[,1]*10, sigma, xi)



}
\author{
Quentin Sebille
}

