// Generated by rstantools.  Do not edit by hand.

/*
    hmde is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hmde is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hmde.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_affine_single_ind_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 106> locations_array__ =
  {" (found before start of program)",
  " (in 'affine_single_ind', line 62, column 2 to column 24)",
  " (in 'affine_single_ind', line 63, column 2 to column 17)",
  " (in 'affine_single_ind', line 64, column 2 to column 27)",
  " (in 'affine_single_ind', line 106, column 2 to column 20)",
  " (in 'affine_single_ind', line 107, column 2 to column 21)",
  " (in 'affine_single_ind', line 108, column 2 to column 18)",
  " (in 'affine_single_ind', line 109, column 2 to column 19)",
  " (in 'affine_single_ind', line 111, column 2 to column 60)",
  " (in 'affine_single_ind', line 112, column 2 to column 60)",
  " (in 'affine_single_ind', line 113, column 2 to column 44)",
  " (in 'affine_single_ind', line 114, column 2 to column 22)",
  " (in 'affine_single_ind', line 115, column 2 to column 23)",
  " (in 'affine_single_ind', line 116, column 2 to column 18)",
  " (in 'affine_single_ind', line 119, column 6 to column 25)",
  " (in 'affine_single_ind', line 118, column 23 to line 120, column 5)",
  " (in 'affine_single_ind', line 118, column 4 to line 120, column 5)",
  " (in 'affine_single_ind', line 124, column 8 to column 75)",
  " (in 'affine_single_ind', line 123, column 25 to line 125, column 7)",
  " (in 'affine_single_ind', line 123, column 6 to line 125, column 7)",
  " (in 'affine_single_ind', line 127, column 8 to column 29)",
  " (in 'affine_single_ind', line 128, column 8 to line 130, column 58)",
  " (in 'affine_single_ind', line 126, column 25 to line 131, column 7)",
  " (in 'affine_single_ind', line 126, column 6 to line 131, column 7)",
  " (in 'affine_single_ind', line 133, column 8 to line 137, column 33)",
  " (in 'affine_single_ind', line 132, column 25 to line 138, column 7)",
  " (in 'affine_single_ind', line 132, column 6 to line 138, column 7)",
  " (in 'affine_single_ind', line 121, column 17 to line 139, column 5)",
  " (in 'affine_single_ind', line 121, column 4 to line 139, column 5)",
  " (in 'affine_single_ind', line 117, column 19 to line 140, column 3)",
  " (in 'affine_single_ind', line 117, column 2 to line 140, column 3)",
  " (in 'affine_single_ind', line 68, column 13 to column 18)",
  " (in 'affine_single_ind', line 68, column 2 to column 20)",
  " (in 'affine_single_ind', line 69, column 2 to column 21)",
  " (in 'affine_single_ind', line 70, column 2 to column 19)",
  " (in 'affine_single_ind', line 71, column 2 to column 22)",
  " (in 'affine_single_ind', line 72, column 2 to column 23)",
  " (in 'affine_single_ind', line 73, column 2 to column 18)",
  " (in 'affine_single_ind', line 76, column 6 to column 25)",
  " (in 'affine_single_ind', line 75, column 23 to line 77, column 5)",
  " (in 'affine_single_ind', line 75, column 4 to line 77, column 5)",
  " (in 'affine_single_ind', line 81, column 8 to column 75)",
  " (in 'affine_single_ind', line 80, column 25 to line 82, column 7)",
  " (in 'affine_single_ind', line 80, column 6 to line 82, column 7)",
  " (in 'affine_single_ind', line 84, column 8 to column 29)",
  " (in 'affine_single_ind', line 85, column 8 to line 87, column 58)",
  " (in 'affine_single_ind', line 83, column 25 to line 88, column 7)",
  " (in 'affine_single_ind', line 83, column 6 to line 88, column 7)",
  " (in 'affine_single_ind', line 90, column 8 to line 94, column 33)",
  " (in 'affine_single_ind', line 89, column 25 to line 95, column 7)",
  " (in 'affine_single_ind', line 89, column 6 to line 95, column 7)",
  " (in 'affine_single_ind', line 78, column 17 to line 96, column 5)",
  " (in 'affine_single_ind', line 78, column 4 to line 96, column 5)",
  " (in 'affine_single_ind', line 74, column 19 to line 97, column 3)",
  " (in 'affine_single_ind', line 74, column 2 to line 97, column 3)",
  " (in 'affine_single_ind', line 99, column 2 to column 29)",
  " (in 'affine_single_ind', line 102, column 2 to column 70)",
  " (in 'affine_single_ind', line 103, column 2 to column 76)",
  " (in 'affine_single_ind', line 49, column 2 to column 17)",
  " (in 'affine_single_ind', line 50, column 2 to column 12)",
  " (in 'affine_single_ind', line 51, column 13 to column 18)",
  " (in 'affine_single_ind', line 51, column 2 to column 20)",
  " (in 'affine_single_ind', line 52, column 16 to column 21)",
  " (in 'affine_single_ind', line 52, column 2 to column 23)",
  " (in 'affine_single_ind', line 53, column 12 to column 17)",
  " (in 'affine_single_ind', line 53, column 2 to column 19)",
  " (in 'affine_single_ind', line 54, column 2 to column 13)",
  " (in 'affine_single_ind', line 55, column 2 to column 17)",
  " (in 'affine_single_ind', line 56, column 2 to column 31)",
  " (in 'affine_single_ind', line 57, column 2 to column 32)",
  " (in 'affine_single_ind', line 106, column 13 to column 18)",
  " (in 'affine_single_ind', line 109, column 9 to column 10)",
  " (in 'affine_single_ind', line 6, column 4 to column 45)",
  " (in 'affine_single_ind', line 5, column 40 to line 7, column 3)",
  " (in 'affine_single_ind', line 9, column 4 to column 12)",
  " (in 'affine_single_ind', line 10, column 4 to column 12)",
  " (in 'affine_single_ind', line 11, column 4 to column 12)",
  " (in 'affine_single_ind', line 12, column 4 to column 12)",
  " (in 'affine_single_ind', line 13, column 4 to column 15)",
  " (in 'affine_single_ind', line 14, column 4 to column 25)",
  " (in 'affine_single_ind', line 15, column 4 to column 41)",
  " (in 'affine_single_ind', line 16, column 4 to column 41)",
  " (in 'affine_single_ind', line 17, column 4 to column 37)",
  " (in 'affine_single_ind', line 18, column 4 to column 67)",
  " (in 'affine_single_ind', line 19, column 4 to column 17)",
  " (in 'affine_single_ind', line 8, column 57 to line 20, column 3)",
  " (in 'affine_single_ind', line 22, column 4 to column 14)",
  " (in 'affine_single_ind', line 23, column 4 to column 18)",
  " (in 'affine_single_ind', line 24, column 4 to column 15)",
  " (in 'affine_single_ind', line 25, column 4 to column 24)",
  " (in 'affine_single_ind', line 26, column 4 to column 17)",
  " (in 'affine_single_ind', line 27, column 4 to column 14)",
  " (in 'affine_single_ind', line 30, column 6 to column 59)",
  " (in 'affine_single_ind', line 32, column 6 to column 52)",
  " (in 'affine_single_ind', line 34, column 6 to column 43)",
  " (in 'affine_single_ind', line 28, column 30 to line 35, column 5)",
  " (in 'affine_single_ind', line 28, column 4 to line 35, column 5)",
  " (in 'affine_single_ind', line 36, column 4 to column 17)",
  " (in 'affine_single_ind', line 21, column 68 to line 37, column 3)",
  " (in 'affine_single_ind', line 39, column 11 to column 18)",
  " (in 'affine_single_ind', line 39, column 4 to column 60)",
  " (in 'affine_single_ind', line 40, column 4 to column 16)",
  " (in 'affine_single_ind', line 38, column 75 to line 41, column 3)",
  " (in 'affine_single_ind', line 43, column 4 to column 37)",
  " (in 'affine_single_ind', line 44, column 4 to column 94)",
  " (in 'affine_single_ind', line 42, column 83 to line 45, column 3)"};
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>>* = nullptr>
stan::promote_args_t<T0__, T1__>
DE_rk4(const T0__& y, const std::vector<T1__>& pars, std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>* = nullptr>
stan::promote_args_t<T0__, T1__, T2__>
rk4_step(const T0__& y, const std::vector<T1__>& pars, const T2__& interval,
         std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__, typename T3__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>* = nullptr>
stan::promote_args_t<T0__, T1__, T2__, T3__>
rk4(const T0__& y, const std::vector<T1__>& pars, const T2__& interval,
    const T3__& step_size, std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__, typename T3__,
          typename T4__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<T0__, stan::base_type_t<T1__>, T2__, T3__,
                T4__>,-1,1>
DE_RK45(const T0__& t, const T1__& y_arg__, const T2__& ind_const,
        const T3__& beta_1, const T4__& y_bar, std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__, typename T3__,
          typename T4__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>* = nullptr>
stan::promote_args_t<T0__, T1__, T2__, T3__, T4__>
analytic_solution(const T0__& t, const T1__& y_0, const T2__& ind_const,
                  const T3__& beta_1, const T4__& y_bar, std::ostream*
                  pstream__);
struct DE_RK45_variadic2_functor__ {
  template <typename T0__, typename T1__, typename T2__, typename T3__,
            typename T4__,
            stan::require_all_t<stan::is_stan_scalar<T0__>,
                                stan::is_col_vector<T1__>,
                                stan::is_vt_not_complex<T1__>,
                                stan::is_stan_scalar<T2__>,
                                stan::is_stan_scalar<T3__>,
                                stan::is_stan_scalar<T4__>>* = nullptr>
  Eigen::Matrix<stan::promote_args_t<T0__, stan::base_type_t<T1__>, T2__,
                  T3__, T4__>,-1,1>
  operator()(const T0__& t, const T1__& y, std::ostream* pstream__,
             const T2__& ind_const, const T3__& beta_1, const T4__& y_bar) const {
    return DE_RK45(t, y, ind_const, beta_1, y_bar, pstream__);
  }
};
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>>*>
stan::promote_args_t<T0__, T1__>
DE_rk4(const T0__& y, const std::vector<T1__>& pars, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 72;
    return (stan::model::rvalue(pars, "pars", stan::model::index_uni(1)) -
           (stan::model::rvalue(pars, "pars", stan::model::index_uni(2)) * (y
           - stan::model::rvalue(pars, "pars", stan::model::index_uni(3)))));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>*>
stan::promote_args_t<T0__, T1__, T2__>
rk4_step(const T0__& y, const std::vector<T1__>& pars, const T2__& interval,
         std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ k1 = DUMMY_VAR__;
    local_scalar_t__ k2 = DUMMY_VAR__;
    local_scalar_t__ k3 = DUMMY_VAR__;
    local_scalar_t__ k4 = DUMMY_VAR__;
    local_scalar_t__ y_hat = DUMMY_VAR__;
    current_statement__ = 79;
    k1 = DE_rk4(y, pars, pstream__);
    current_statement__ = 80;
    k2 = DE_rk4((y + ((interval * k1) / 2.0)), pars, pstream__);
    current_statement__ = 81;
    k3 = DE_rk4((y + ((interval * k2) / 2.0)), pars, pstream__);
    current_statement__ = 82;
    k4 = DE_rk4((y + (interval * k3)), pars, pstream__);
    current_statement__ = 83;
    y_hat = (y + (((1.0 / 6.0) * (((k1 + (2.0 * k2)) + (2.0 * k3)) + k4)) *
      interval));
    current_statement__ = 84;
    return y_hat;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__, typename T3__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>*>
stan::promote_args_t<T0__, T1__, T2__, T3__>
rk4(const T0__& y, const std::vector<T1__>& pars, const T2__& interval,
    const T3__& step_size, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__, T3__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int steps = std::numeric_limits<int>::min();
    local_scalar_t__ duration = DUMMY_VAR__;
    local_scalar_t__ y_hat = DUMMY_VAR__;
    local_scalar_t__ step_size_temp = DUMMY_VAR__;
    current_statement__ = 90;
    duration = 0;
    current_statement__ = 91;
    y_hat = y;
    current_statement__ = 96;
    while (stan::math::logical_lt(duration, interval)) {
      current_statement__ = 92;
      step_size_temp = stan::math::min(
                         (Eigen::Matrix<local_scalar_t__,1,-1>(2) <<
                                                                    step_size,
                                                                    (interval
                                                                    -
                                                                    duration)).finished());
      current_statement__ = 93;
      y_hat = rk4_step(y_hat, pars, step_size_temp, pstream__);
      current_statement__ = 94;
      duration = (duration + step_size_temp);
    }
    current_statement__ = 97;
    return y_hat;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__, typename T3__,
          typename T4__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>*>
Eigen::Matrix<stan::promote_args_t<T0__, stan::base_type_t<T1__>, T2__, T3__,
                T4__>,-1,1>
DE_RK45(const T0__& t, const T1__& y_arg__, const T2__& ind_const,
        const T3__& beta_1, const T4__& y_bar, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
                             stan::base_type_t<T1__>, T2__, T3__, T4__>;
  int current_statement__ = 0;
  const auto& y = stan::math::to_ref(y_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 99;
    stan::math::validate_non_negative_index("dydt", "size(y)",
      stan::math::size(y));
    Eigen::Matrix<local_scalar_t__,-1,1> dydt =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(stan::math::size(y),
        DUMMY_VAR__);
    current_statement__ = 100;
    stan::model::assign(dydt,
      stan::math::subtract(ind_const,
        stan::math::multiply(beta_1, stan::math::subtract(y, y_bar))),
      "assigning variable dydt");
    current_statement__ = 101;
    return dydt;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__, typename T3__,
          typename T4__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>*>
stan::promote_args_t<T0__, T1__, T2__, T3__, T4__>
analytic_solution(const T0__& t, const T1__& y_0, const T2__& ind_const,
                  const T3__& beta_1, const T4__& y_bar, std::ostream*
                  pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__, T3__, T4__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ y_0_translate = DUMMY_VAR__;
    current_statement__ = 103;
    y_0_translate = (y_0 - y_bar);
    current_statement__ = 104;
    return (((ind_const / beta_1) + ((y_0_translate - (ind_const / beta_1)) *
           stan::math::exp((-beta_1 * t)))) + y_bar);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_affine_single_ind final : public model_base_crtp<model_affine_single_ind> {
private:
  double step_size;
  int n_obs;
  std::vector<double> y_obs;
  std::vector<int> obs_index;
  std::vector<double> time;
  double y_bar;
  int int_method;
  std::vector<double> prior_pars_ind_const;
  std::vector<double> prior_pars_ind_beta_1;
public:
  ~model_affine_single_ind() {}
  model_affine_single_ind(stan::io::var_context& context__, unsigned int
                          random_seed__ = 0, std::ostream*
                          pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_affine_single_ind_namespace::model_affine_single_ind";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 58;
      context__.validate_dims("data initialization", "step_size", "double",
        std::vector<size_t>{});
      step_size = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 58;
      step_size = context__.vals_r("step_size")[(1 - 1)];
      current_statement__ = 59;
      context__.validate_dims("data initialization", "n_obs", "int",
        std::vector<size_t>{});
      n_obs = std::numeric_limits<int>::min();
      current_statement__ = 59;
      n_obs = context__.vals_i("n_obs")[(1 - 1)];
      current_statement__ = 60;
      stan::math::validate_non_negative_index("y_obs", "n_obs", n_obs);
      current_statement__ = 61;
      context__.validate_dims("data initialization", "y_obs", "double",
        std::vector<size_t>{static_cast<size_t>(n_obs)});
      y_obs = std::vector<double>(n_obs,
                std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 61;
      y_obs = context__.vals_r("y_obs");
      current_statement__ = 62;
      stan::math::validate_non_negative_index("obs_index", "n_obs", n_obs);
      current_statement__ = 63;
      context__.validate_dims("data initialization", "obs_index", "int",
        std::vector<size_t>{static_cast<size_t>(n_obs)});
      obs_index = std::vector<int>(n_obs, std::numeric_limits<int>::min());
      current_statement__ = 63;
      obs_index = context__.vals_i("obs_index");
      current_statement__ = 64;
      stan::math::validate_non_negative_index("time", "n_obs", n_obs);
      current_statement__ = 65;
      context__.validate_dims("data initialization", "time", "double",
        std::vector<size_t>{static_cast<size_t>(n_obs)});
      time = std::vector<double>(n_obs,
               std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 65;
      time = context__.vals_r("time");
      current_statement__ = 66;
      context__.validate_dims("data initialization", "y_bar", "double",
        std::vector<size_t>{});
      y_bar = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 66;
      y_bar = context__.vals_r("y_bar")[(1 - 1)];
      current_statement__ = 67;
      context__.validate_dims("data initialization", "int_method", "int",
        std::vector<size_t>{});
      int_method = std::numeric_limits<int>::min();
      current_statement__ = 67;
      int_method = context__.vals_i("int_method")[(1 - 1)];
      current_statement__ = 68;
      context__.validate_dims("data initialization", "prior_pars_ind_const",
        "double", std::vector<size_t>{static_cast<size_t>(2)});
      prior_pars_ind_const = std::vector<double>(2,
                               std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 68;
      prior_pars_ind_const = context__.vals_r("prior_pars_ind_const");
      current_statement__ = 69;
      context__.validate_dims("data initialization", "prior_pars_ind_beta_1",
        "double", std::vector<size_t>{static_cast<size_t>(2)});
      prior_pars_ind_beta_1 = std::vector<double>(2,
                                std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 69;
      prior_pars_ind_beta_1 = context__.vals_r("prior_pars_ind_beta_1");
      current_statement__ = 70;
      stan::math::validate_non_negative_index("y_hat", "n_obs", n_obs);
      current_statement__ = 71;
      stan::math::validate_non_negative_index("y_temp", "1", 1);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + 1 + 1;
  }
  inline std::string model_name() const final {
    return "model_affine_single_ind";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_affine_single_ind_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ ind_y_0 = DUMMY_VAR__;
      current_statement__ = 1;
      ind_y_0 = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      local_scalar_t__ ind_const = DUMMY_VAR__;
      current_statement__ = 2;
      ind_const = in__.template read<local_scalar_t__>();
      local_scalar_t__ ind_beta_1 = DUMMY_VAR__;
      current_statement__ = 3;
      ind_beta_1 = in__.template read_constrain_lb<local_scalar_t__,
                     jacobian__>(0, lp__);
      {
        current_statement__ = 31;
        stan::math::validate_non_negative_index("y_hat", "n_obs", n_obs);
        std::vector<local_scalar_t__> y_hat =
          std::vector<local_scalar_t__>(n_obs, DUMMY_VAR__);
        std::vector<local_scalar_t__> pars =
          std::vector<local_scalar_t__>(3, DUMMY_VAR__);
        Eigen::Matrix<local_scalar_t__,-1,1> y_temp =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(1, DUMMY_VAR__);
        current_statement__ = 35;
        stan::model::assign(pars, ind_const, "assigning variable pars",
          stan::model::index_uni(1));
        current_statement__ = 36;
        stan::model::assign(pars, ind_beta_1, "assigning variable pars",
          stan::model::index_uni(2));
        current_statement__ = 37;
        stan::model::assign(pars, y_bar, "assigning variable pars",
          stan::model::index_uni(3));
        current_statement__ = 54;
        for (int i = 1; i <= n_obs; ++i) {
          current_statement__ = 40;
          if (stan::math::logical_eq(
                stan::model::rvalue(obs_index, "obs_index",
                  stan::model::index_uni(i)), 1)) {
            current_statement__ = 38;
            stan::model::assign(y_hat, ind_y_0, "assigning variable y_hat",
              stan::model::index_uni(i));
          }
          current_statement__ = 52;
          if (stan::math::logical_lt(i, n_obs)) {
            current_statement__ = 43;
            if (stan::math::logical_eq(int_method, 1)) {
              current_statement__ = 41;
              stan::model::assign(y_hat,
                rk4(
                  stan::model::rvalue(y_hat, "y_hat",
                    stan::model::index_uni(i)), pars,
                  (stan::model::rvalue(time, "time",
                     stan::model::index_uni((i + 1))) -
                  stan::model::rvalue(time, "time", stan::model::index_uni(i))),
                  step_size, pstream__), "assigning variable y_hat",
                stan::model::index_uni((i + 1)));
            }
            current_statement__ = 47;
            if (stan::math::logical_eq(int_method, 2)) {
              current_statement__ = 44;
              stan::model::assign(y_temp,
                stan::model::rvalue(y_hat, "y_hat", stan::model::index_uni(i)),
                "assigning variable y_temp", stan::model::index_uni(1));
              current_statement__ = 45;
              stan::model::assign(y_hat,
                stan::model::rvalue(
                  stan::model::rvalue(
                    stan::math::ode_rk45(DE_RK45_variadic2_functor__(),
                      y_temp,
                      stan::model::rvalue(time, "time",
                        stan::model::index_uni(i)),
                      std::vector<double>{stan::model::rvalue(time, "time",
                                            stan::model::index_uni((i + 1)))},
                      pstream__, ind_const, ind_beta_1, y_bar),
                    "ode_rk45(DE_RK45, y_temp, time[i], FnMakeArray__(time[(i + 1)]), ind_const,\nind_beta_1,\ny_bar)",
                    stan::model::index_uni(1)),
                  "ode_rk45(DE_RK45, y_temp, time[i], FnMakeArray__(time[(i + 1)]), ind_const,\nind_beta_1, y_bar)[1]",
                  stan::model::index_uni(1)), "assigning variable y_hat",
                stan::model::index_uni((i + 1)));
            }
            current_statement__ = 50;
            if (stan::math::logical_eq(int_method, 3)) {
              current_statement__ = 48;
              stan::model::assign(y_hat,
                analytic_solution(
                  (stan::model::rvalue(time, "time",
                     stan::model::index_uni((i + 1))) -
                  stan::model::rvalue(time, "time", stan::model::index_uni(1))),
                  ind_y_0, ind_const, ind_beta_1, y_bar, pstream__),
                "assigning variable y_hat", stan::model::index_uni((i + 1)));
            }
          }
        }
        current_statement__ = 55;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(y_obs, y_hat, 0.1));
        current_statement__ = 56;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(ind_const,
                         stan::model::rvalue(prior_pars_ind_const,
                           "prior_pars_ind_const", stan::model::index_uni(1)),
                         stan::model::rvalue(prior_pars_ind_const,
                           "prior_pars_ind_const", stan::model::index_uni(2))));
        current_statement__ = 57;
        lp_accum__.add(stan::math::lognormal_lpdf<propto__>(ind_beta_1,
                         stan::model::rvalue(prior_pars_ind_beta_1,
                           "prior_pars_ind_beta_1", stan::model::index_uni(1)),
                         stan::model::rvalue(prior_pars_ind_beta_1,
                           "prior_pars_ind_beta_1", stan::model::index_uni(2))));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_affine_single_ind_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double ind_y_0 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      ind_y_0 = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      double ind_const = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      ind_const = in__.template read<local_scalar_t__>();
      double ind_beta_1 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      ind_beta_1 = in__.template read_constrain_lb<local_scalar_t__,
                     jacobian__>(0, lp__);
      out__.write(ind_y_0);
      out__.write(ind_const);
      out__.write(ind_beta_1);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<double> y_hat =
        std::vector<double>(n_obs, std::numeric_limits<double>::quiet_NaN());
      std::vector<double> pars =
        std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      double ind_beta_0 = std::numeric_limits<double>::quiet_NaN();
      Eigen::Matrix<double,-1,1> y_temp =
        Eigen::Matrix<double,-1,1>::Constant(1,
          std::numeric_limits<double>::quiet_NaN());
      std::vector<double> check_prior_pars_ind_const =
        std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 8;
      stan::model::assign(check_prior_pars_ind_const, prior_pars_ind_const,
        "assigning variable check_prior_pars_ind_const");
      std::vector<double> check_prior_pars_ind_beta =
        std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 9;
      stan::model::assign(check_prior_pars_ind_beta, prior_pars_ind_beta_1,
        "assigning variable check_prior_pars_ind_beta");
      current_statement__ = 10;
      ind_beta_0 = (ind_const + (ind_beta_1 * y_bar));
      current_statement__ = 11;
      stan::model::assign(pars, ind_const, "assigning variable pars",
        stan::model::index_uni(1));
      current_statement__ = 12;
      stan::model::assign(pars, ind_beta_1, "assigning variable pars",
        stan::model::index_uni(2));
      current_statement__ = 13;
      stan::model::assign(pars, y_bar, "assigning variable pars",
        stan::model::index_uni(3));
      current_statement__ = 30;
      for (int i = 1; i <= n_obs; ++i) {
        current_statement__ = 16;
        if (stan::math::logical_eq(
              stan::model::rvalue(obs_index, "obs_index",
                stan::model::index_uni(i)), 1)) {
          current_statement__ = 14;
          stan::model::assign(y_hat, ind_y_0, "assigning variable y_hat",
            stan::model::index_uni(i));
        }
        current_statement__ = 28;
        if (stan::math::logical_lt(i, n_obs)) {
          current_statement__ = 19;
          if (stan::math::logical_eq(int_method, 1)) {
            current_statement__ = 17;
            stan::model::assign(y_hat,
              rk4(
                stan::model::rvalue(y_hat, "y_hat", stan::model::index_uni(i)),
                pars,
                (stan::model::rvalue(time, "time",
                   stan::model::index_uni((i + 1))) -
                stan::model::rvalue(time, "time", stan::model::index_uni(i))),
                step_size, pstream__), "assigning variable y_hat",
              stan::model::index_uni((i + 1)));
          }
          current_statement__ = 23;
          if (stan::math::logical_eq(int_method, 2)) {
            current_statement__ = 20;
            stan::model::assign(y_temp,
              stan::model::rvalue(y_hat, "y_hat", stan::model::index_uni(i)),
              "assigning variable y_temp", stan::model::index_uni(1));
            current_statement__ = 21;
            stan::model::assign(y_hat,
              stan::model::rvalue(
                stan::model::rvalue(
                  stan::math::ode_rk45(DE_RK45_variadic2_functor__(), y_temp,
                    stan::model::rvalue(time, "time",
                      stan::model::index_uni(i)),
                    std::vector<double>{stan::model::rvalue(time, "time",
                                          stan::model::index_uni((i + 1)))},
                    pstream__, ind_const, ind_beta_1, y_bar),
                  "ode_rk45(DE_RK45, y_temp, time[i], FnMakeArray__(time[(i + 1)]), ind_const,\nind_beta_1,\ny_bar)",
                  stan::model::index_uni(1)),
                "ode_rk45(DE_RK45, y_temp, time[i], FnMakeArray__(time[(i + 1)]), ind_const,\nind_beta_1, y_bar)[1]",
                stan::model::index_uni(1)), "assigning variable y_hat",
              stan::model::index_uni((i + 1)));
          }
          current_statement__ = 26;
          if (stan::math::logical_eq(int_method, 3)) {
            current_statement__ = 24;
            stan::model::assign(y_hat,
              analytic_solution(
                (stan::model::rvalue(time, "time",
                   stan::model::index_uni((i + 1))) -
                stan::model::rvalue(time, "time", stan::model::index_uni(1))),
                ind_y_0, ind_const, ind_beta_1, y_bar, pstream__),
              "assigning variable y_hat", stan::model::index_uni((i + 1)));
          }
        }
      }
      out__.write(y_hat);
      out__.write(pars);
      out__.write(ind_beta_0);
      out__.write(y_temp);
      out__.write(check_prior_pars_ind_const);
      out__.write(check_prior_pars_ind_beta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ ind_y_0 = DUMMY_VAR__;
      current_statement__ = 1;
      ind_y_0 = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, ind_y_0);
      local_scalar_t__ ind_const = DUMMY_VAR__;
      current_statement__ = 2;
      ind_const = in__.read<local_scalar_t__>();
      out__.write(ind_const);
      local_scalar_t__ ind_beta_1 = DUMMY_VAR__;
      current_statement__ = 3;
      ind_beta_1 = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, ind_beta_1);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "ind_y_0",
        "double", std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "ind_const",
        "double", std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "ind_beta_1",
        "double", std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ ind_y_0 = DUMMY_VAR__;
      current_statement__ = 1;
      ind_y_0 = context__.vals_r("ind_y_0")[(1 - 1)];
      out__.write_free_lb(0, ind_y_0);
      local_scalar_t__ ind_const = DUMMY_VAR__;
      current_statement__ = 2;
      ind_const = context__.vals_r("ind_const")[(1 - 1)];
      out__.write(ind_const);
      local_scalar_t__ ind_beta_1 = DUMMY_VAR__;
      current_statement__ = 3;
      ind_beta_1 = context__.vals_r("ind_beta_1")[(1 - 1)];
      out__.write_free_lb(0, ind_beta_1);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"ind_y_0", "ind_const", "ind_beta_1"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::string>
        temp{"y_hat", "pars", "ind_beta_0", "y_temp",
             "check_prior_pars_ind_const", "check_prior_pars_ind_beta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n_obs)},
             std::vector<size_t>{static_cast<size_t>(3)},
             std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(1)},
             std::vector<size_t>{static_cast<size_t>(2)},
             std::vector<size_t>{static_cast<size_t>(2)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "ind_y_0");
    param_names__.emplace_back(std::string() + "ind_const");
    param_names__.emplace_back(std::string() + "ind_beta_1");
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_obs; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_hat" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        param_names__.emplace_back(std::string() + "pars" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "ind_beta_0");
      for (int sym1__ = 1; sym1__ <= 1; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_temp" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        param_names__.emplace_back(std::string() +
          "check_prior_pars_ind_const" + '.' + std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        param_names__.emplace_back(std::string() +
          "check_prior_pars_ind_beta" + '.' + std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "ind_y_0");
    param_names__.emplace_back(std::string() + "ind_const");
    param_names__.emplace_back(std::string() + "ind_beta_1");
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_obs; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_hat" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        param_names__.emplace_back(std::string() + "pars" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "ind_beta_0");
      for (int sym1__ = 1; sym1__ <= 1; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_temp" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        param_names__.emplace_back(std::string() +
          "check_prior_pars_ind_const" + '.' + std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        param_names__.emplace_back(std::string() +
          "check_prior_pars_ind_beta" + '.' + std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"ind_y_0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"ind_const\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"ind_beta_1\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"y_hat\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n_obs) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"pars\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(3) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"ind_beta_0\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"y_temp\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(1) + "},\"block\":\"generated_quantities\"},{\"name\":\"check_prior_pars_ind_const\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(2) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"check_prior_pars_ind_beta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(2) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"ind_y_0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"ind_const\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"ind_beta_1\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"y_hat\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n_obs) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"pars\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(3) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"ind_beta_0\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"y_temp\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(1) + "},\"block\":\"generated_quantities\"},{\"name\":\"check_prior_pars_ind_const\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(2) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"check_prior_pars_ind_beta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(2) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((1 + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * ((((((n_obs
      + 3) + 1) + 1) + 2) + 2));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((1 + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * ((((((n_obs
      + 3) + 1) + 1) + 2) + 2));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_affine_single_ind_namespace::model_affine_single_ind;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_affine_single_ind_namespace::profiles__;
}
#endif
#endif
