% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelbuilding.R
\name{variance_emulator_from_data}
\alias{variance_emulator_from_data}
\title{Variance Emulator Creation}
\usage{
variance_emulator_from_data(
  input_data,
  output_names,
  ranges,
  input_names = names(ranges),
  verbose = interactive(),
  ...
)
}
\arguments{
\item{input_data}{All model runs at all points.}

\item{output_names}{The observation names.}

\item{ranges}{A named list of parameter ranges}

\item{input_names}{The names of the parameters (if \code{ranges} is not provided).}

\item{verbose}{Should status updates be printed to console?}

\item{...}{Optional parameters that can be passed to \code{link{emulator_from_data}}.}
}
\value{
A list of lists: one for the variance emulators and one for the function emulators.
}
\description{
Trains hierarchical emulators to stochastic systems
}
\details{
For stochastic systems, one may emulate the variance as well as the function itself.
This is particularly true if one expects the variance to be very different in different
areas of the parameter space (for example, in an epidemic model). This function performs
the requisite two-stage Bayes Linear update.

All observations are required (including replicates at points) - this function collects
them into the required chunks and calculates the summary statistics as required.

All other parameters passed to this function are equivalent to those in
emulators are the Bayes Linear adjusted forms.
}
\examples{
 # A simple example using the BirthDeath dataset
 v_ems <- variance_emulator_from_data(BirthDeath$training, c("Y"),
  list(lambda = c(0, 0.08), mu = c(0.04, 0.13)), c_lengths = c(0.75))

}
\references{
Goldstein & Vernon (2016) in preparation
}
