% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idemc.R
\name{idemc}
\alias{idemc}
\title{IDEMC Point Generation}
\usage{
idemc(
  ems,
  N,
  targets,
  cutoff = 3,
  s = max(500, ceiling(N/5)),
  sn = s,
  p = 0.4,
  thin = 1,
  pm = 0.9,
  w = 0.8,
  M = 10,
  detailed = FALSE,
  verbose = interactive(),
  get_burnt = FALSE,
  burnt = NULL
)
}
\arguments{
\item{ems}{The emulators to evaluate implausibility on}

\item{N}{The desired number of final points to generate}

\item{targets}{The target values for the emulated outputs}

\item{cutoff}{The desired implausibility cutoff of the final proposal}

\item{s}{The number of points to generate at intermediate burn-in steps}

\item{sn}{The number of points to generate at the final burn-in stage}

\item{p}{The proportion of space that should remain between ladder rungs}

\item{thin}{The thinning factor: a factor T means N*T points are generated to obtain N}

\item{pm}{The probability that an idemc step will use mutation moves}

\item{w}{The probability of local random walks in the mutation step}

\item{M}{The number of mutations to perform in an IDEMC step}

\item{detailed}{If TRUE, points proposed at every rung will be returned}

\item{verbose}{Should information about burn-in be displayed during the process?}

\item{get_burnt}{If TRUE, the procedure stops after burn-in, returning seeding for a full IDEMC proposal}

\item{burnt}{If provided, this is assumed to be the result of a burn-in (or a priori analysis)}
}
\value{
Either a list of data.frames, one per rung, or a single data.frame of points.
}
\description{
Performs Implausibility-driven Evolutionary Monte Carlo
}
\details{
This method for generating points is focused on finding non-implausible
regions that are either extremely small relative to the initial parameter
domain, or have interesting structure (particularly disconnected structure)
that would potentially be overlooked by more standard point generation methods.
The method is robust but computationally intensive, compared to normal methods,
and should not be used as a default - see \code{\link{generate_new_runs}} for
less computationally expensive methods.

The IDEMC method operates on an 'implausibility ladder', in the vein of common
annealing methods. Each rung of the ladder is characterised by the implausibility
threshold, and determinations are made about the structure of the points in each
rung using clustering. One step of the evolutionary algorithm can consist of the
following steps:

Mutation. A point is modified using a random-walk proposal, which can be a global
move or a within-cluster move. Within-cluster moves are chosen with probability
\code{w}. The move is retained if the new point satisfies the implausibility
constraints of the rung.

Crossover. Points are re-organised in descending order of how active each variable
is for the emulated outputs, and two different rungs are selected randomly. The
points are 'mixed' using one-point real crossover at a random crossover point,
producing two new points. The move is retained if both new points satisfy the
relevant implausibility constraints of their rung.

Exchange. Two adjacent rungs are chosen and their points are swapped. The move
is retained if the higher-implausibility rung is appropriate for being in the
lower implausibility rung.

At a given step, one of mutation or crossover is performed, with probability
of mutation being chosen determined by \code{pm}. If mutation is chosen, then
\code{M} mutation moves are performed; else \code{(n+1)/2} crossover moves are
performed on the \code{n} rungs. Exchange is always perfomed and \code{n+1} such
moves are performed.

The choice of 'implausibility ladder' and clusters can be determined a priori,
or else this function performs a burn-in phase to determine them. Points are
generated using the idemc steps at the current rungs, and the next ladder rung
implausibility is chosen by requiring that a proportion \code{p} of points from
the previous rung are accepted in the new one. At each stage, \code{s} idemc
steps are performed. Once the final rung has implausibility no larger than the
desired \code{cutoff}, a final set of \code{sn} idemc steps are performed across
all rungs to determine final clusters.
}
\examples{
 \donttest{
  idemc_res <- idemc(SIREmulators$ems, 200, SIREmulators$targets, s = 100, p = 0.3)
 }

}
\references{
Vernon & Williamson (2013) <arXiv:1309.3520>
}
\seealso{
\code{\link{generate_new_runs}} for more standard point generation methods
}
