% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_wrap}
\alias{plot_wrap}
\title{Plot proposed points}
\usage{
plot_wrap(points, ranges = NULL, p_size = 0.5)
}
\arguments{
\item{points}{The points to plot}

\item{ranges}{The parameter ranges}

\item{p_size}{The size of the plotted points (passed to \code{cex})}
}
\value{
The corresponding pairs plot
}
\description{
A wrapper around R's base plot to show proposed points
}
\details{
Given a set of points proposed from emulators at a given wave, it's often useful to look at
how they are spread and where in parameter space they tend to lie relative to the original
ranges of the parameters. This function provides pairs plots of the parameters, with the
bounds of the plots calculated with respect to the parameter ranges provided.
}
\examples{
 plot_wrap(SIRSample$training[,1:3], SIREmulators$ems[[1]]$ranges)

}
\seealso{
Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{effect_strength}()},
\code{\link{emulator_plot}()},
\code{\link{hit_by_wave}()},
\code{\link{output_plot}()},
\code{\link{plot_actives}()},
\code{\link{plot_lattice}()},
\code{\link{simulator_plot}()},
\code{\link{space_removed}()},
\code{\link{validation_pairs}()},
\code{\link{wave_dependencies}()},
\code{\link{wave_points}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
