% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_imp_semicont_single_2017-04-11.R
\name{imp_semicont_single}
\alias{imp_semicont_single}
\title{The function for hierarchical imputation of semicontinuous variables.}
\usage{
imp_semicont_single(y_imp, X_imp, heap = 0, pvalue = 0.2,
  rounding_degrees = c(1, 10, 100, 1000))
}
\arguments{
\item{y_imp}{A Vector with the variable to impute.}

\item{X_imp}{A data.frame with the fixed effects variables.}

\item{heap}{A numeric value saying to which value the data might be heaped.}

\item{pvalue}{A numeric between 0 and 1 denoting the threshold of p-values a variable in the imputation
model should not exceed. If they do, they are excluded from the imputation model.}

\item{rounding_degrees}{A numeric vector with the presumed rounding degrees.}
}
\value{
A n x 1 data.frame with the original and imputed values.
}
\description{
The function is called by the wrapper. We consider data to be "semicontinuous" when
more than 5\% of the (non categorical) observations.\cr
For example in surveys a certain portion of people, when asked for their income,
report "0", which clearly violates the assumption of income to be (log-) normally distributed.
}
