% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2018-01-31.R
\name{plot.interval}
\alias{plot.interval}
\title{Plotting interval variables}
\usage{
\method{plot}{interval}(x = NULL, y = NULL, data = NULL, col = "black",
  xlab = NULL, ylab = NULL, xlim = NULL, ylim = NULL, sort = NULL,
  ...)
}
\arguments{
\item{x}{In its most save way, \code{x} is an object from class \code{interval}
and jointly used with a second \code{interval} object \code{y}. If no \code{y} is given,
the values of \code{x} are just plotted in order of appearance
(cf. \code{plot(iris$Sepal.Length)}).
\code{x} can also be a \code{formula} with two variables found in \code{data}.}

\item{y}{If used jointly with \code{x}, it has to be a numeric vector or an \code{interval} object.}

\item{data}{If \code{x} is a \code{fomula}, it has to be a data.frame or matrix with column names
fitting to the two variables named in the formula.}

\item{col}{The color of the rectangles.}

\item{xlab}{A title for the x axis: see \code{title}.}

\item{ylab}{A title for the y axis: see \code{title}.}

\item{xlim}{Numeric vectors of length 2, giving the x coordinate ranges.}

\item{ylim}{Numeric vectors of length 2, giving the y coordinate ranges.}

\item{sort}{A character specifiying how the values should be sorted if only one variable is to be plotted.
By default they are sorted according to their position in the data set.
Currently, the only option to chose (\code{sort = "mostprecise_increasing"}) is to sort them by their length of the interval they represent,
and within equal lengths increasing with the lower bound.}

\item{...}{graphical parameters such as \code{main}.}
}
\description{
Function to plot interval variables by rectangles. The bounds of the rectangles are given by the
lower and upper bounds of the interval variables. To avoid precise observations to have a line-width
of 0, small values are added to the upper and lower bounds what guarantees the rectangles (or lines or points)
to be easily visible in the plot.
}
\examples{
\dontrun{
#Works like plot:
plot.interval(Sepal.Length ~ Sepal.Width, data = iris)
#But designed to plot interval objects:
plot.interval(x = artificial$age, y = artificial$income)
}
}
