\name{misstify}
\alias{misstify}
\title{
  Insert missing values.
}
\description{
  Insert missing values into data simulated by \code{rhmm}.
}
\usage{
misstify(X, nafrac, fep = NULL)
}
\arguments{
  \item{X}{
  A data set (list of matrices with one or two columns, or list of
  such list) generated by \code{\link{rhmm}()}.
}
  \item{nafrac}{A scalar probability or a vector of two such
  probabilities if the data are bivariate.  The values should in
  all cases be numbers between zero and 1.  These values represent
  the fraction of missing values in the data (or in the respective
  components of the data if the model is bivariate).  If the data
  are bivariate \code{nafrac} is duplicated if it is of length 1.
  If an entry of \code{nafrac} is equal to 1, an error is thrown.
  (Having \emph{everything} missing makes no sense!)

  The fraction(s) of missing values in a given data set may be
  determined by \code{\link{nafracCalc}()}.
}
  \item{fep}{
  \dQuote{First entry present}.  A list with one or two
  entries, the first being a logical scalar (which might be named
  \code{"present"}.  If there is a second entry it should be a scalar
  probability (which might be named \code{"p2"}).  In an application
  of interest, observation sequences always begin at an observed
  event, i.e. at a time point at which the \dQuote{emission} has at
  least one non-missing value.  If \code{fep[[1]]} is \code{TRUE}
  the \code{NA}s will be inserted in such a way that the resulting
  data have this characteristic.  If \code{fep} is left \code{NULL}
  then its first (possibly only) entry is set to \code{TRUE}.

  For \emph{bivariate} data, \code{fep[[2]]} specifies the probabilty
  that \emph{both} values of the initial pair of observations are
  non-missing.  In this case one of the entries of the initial pair
  is chosen to be \dQuote{potentially} missing, with probabilities
  \code{nafrac/sum(nafrac)}.  This entry is left non-missing with
  probability \code{fep[[2]]}.  (The other entry is always left
  non-missing.)

  If the data are univariate or if \code{fep[[1]]} is \code{FALSE},
  then \code{fep[[2]]} is ignored.  If the data are bivariate
  and \code{fep[[2]]} is not specified, it defaults to the (estimated)
  conditional probability that both entries of the initial pair
  of observations are present given that at least one is present,
  under the assumption of independence of these events.  I.e. it is
  set equal to \code{prod(1-nafrac)/(1-prod(1-nafrac))}.
}
}

\value{
A list, like that returned by \code{\link{rhmm}()}.
The latter function calls upon \code{misstify()} to effect the
replacement of observations by the appropriate (or specified)
fraction of missing values.
}
\author{Rolf Turner
  \email{r.turner@auckland.ac.nz}\cr
}

\seealso{
\code{\link{rhmm}()} \code{\link{nafracCalc}()}
}
\examples{
P <- matrix(c(0.7,0.3,0.1,0.9),2,2,byrow=TRUE)
R <- matrix(c(0.5,0,0.1,0.1,0.3,
              0.1,0.1,0,0.3,0.5),5,2)
set.seed(42)
lll   <- sample(250:350,20,TRUE)
y     <- rhmm(ylengths=lll,nsim=1,tpm=P,Rho=R,drop=TRUE)
y     <- misstify(y,nafrac=0.5,fep=list(present=TRUE))
}

\keyword{datagen}
