% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_mat.R
\name{make_matrices}
\alias{make_matrices}
\title{Create model matrices}
\usage{
make_matrices(formulas, data, new_data = NULL)
}
\arguments{
\item{formulas}{List of formulas (possibly nested, e.g. for use within Observation)}

\item{data}{Data frame including covariates}

\item{new_data}{Optional new data set, including covariates for which
the design matrices should be created. This needs to be passed in addition
to the argument '\code{data}', for cases where smooth terms or factor
covariates are included, and the original data set is needed to determine
the full range of covariate values.}
}
\value{
A list of
\itemize{
  \item X_fe Design matrix for fixed effects
  \item X_re Design matrix for random effects
  \item S Smoothness matrix
  \item ncol_fe Number of columns of X_fe for each parameter
  \item ncol_re Number of columns of X_re and S for each random effect
}
}
\description{
Create model matrices
}
