\name{plot.nlreg.profiles}
\alias{plot.nlreg.profile}
\alias{plot.all.nlreg.profiles}
\title{
  Use plot() on a `profile.nlreg' and `all.profiles.nlreg' object
}
\description{
  These are methods for the function \code{plot} for objects 
  inheriting from class \code{"profile.nlreg"} or 
  \code{"all.profiles.nlreg"} .  
}
\usage{
\method{plot}{nlreg.profile}(x, alpha = 0.05, add.leg = FALSE, stats = c("sk", "fr"), 
     cex = 0.7, cex.lab = 1, cex.axis = 1, cex.main = 1, lwd1 = 1, lwd2 = 2, 
     lty1 = "solid", lty2 = "solid", cl1 = "blue", cl2 = "red", col = "black", 
     ylim = c(-3,3), \dots)
\method{plot}{all.nlreg.profiles}(x, nframe, alpha = 0.05, stats = c("sk", "fr"), 
     cex = 0.7, cex.lab = 1, cex.axis = 1, cex.main = 1, lwd1 = 1, lwd2 = 2, 
     lty1 = "solid", lty2 = "solid", cl1 = "blue", cl2 = "red", col = "black", 
     ylim = c(-3,3), \dots)
}
\synopsis{
\method{plot}{nlreg.profile}(x = stop("nothing to plot"), alpha = 0.05, add.leg = FALSE, stats = c("sk", "fr"), 
     cex = 0.7, cex.lab = 1, cex.axis = 1, cex.main = 1, lwd1 = 1, lwd2 = 2, 
     lty1 = "solid", lty2 = "solid", cl1 = "blue", cl2 = "red", col = "black", 
     ylim = c(-3,3), \dots)
\method{plot}{all.nlreg.profiles}(x = stop("nothing to plot"), nframe, alpha = 0.05, stats = c("sk", "fr"), 
     cex = 0.7, cex.lab = 1, cex.axis = 1, cex.main = 1, lwd1 = 1, lwd2 = 2, 
     lty1 = "solid", lty2 = "solid", cl1 = "blue", cl2 = "red", col = "black", 
     ylim = c(-3,3), \dots)
}
\arguments{
  \item{x}{
    an object of class \code{profile.nlreg} or 
    \code{all.profiles.nlreg} such as generated by a call to 
    \code{\link[nlreg]{profile.nlreg}}.
  }
  \item{nframe}{
    the number of frames into which to split the graphics device; 
    only if \code{x} is an \code{all.profiles.nlreg} object.
  }
  \item{alpha}{
    numeric vector with the levels used to read off confidence 
    intervals; the default is 5\% which corresponds to a confidence
    level of \eqn{1-\alpha=0.95}{1-\code{alpha}=0.95}. 
  }
  \item{stats}{
    character value indicating which higher order statistics to plot.  
    Admissible values are \code{"sk"} for \cite{Skovgaard's (1996)} 
    proposal and \code{"fr"} for \cite{Fraser, Reid and Wu's (1999)}
    approach.  The default is \code{"sk"}.
  }
  \item{add.leg}{
    logical value indicating whether a legend should be added to the 
    plot; only if \code{x} is a \code{profile.nlreg} object.  The 
    default is \code{FALSE}.
  }
  \item{cex, cex.lab, cex.axis, cex.main}{
    the character expansions relative to the standard size of the 
    device to be used for printing text, labels, axes and main title.
    See \code{\link[graphics]{par}} for details. 
  }
  \item{lwd1, lwd2}{
    the line widths used to compare different curves in the same 
    plot; default is \code{lwd2 = 2} for higher order solutions and 
    \code{lwd1 = 1} for first order solutions.
  }
  \item{lty1, lty2}{
    line types used to compare different curves in the same plot; 
    default is \code{"solid"} for all statistics. 
  }
  \item{cl1, cl2, col}{
    colors used to compare different curves in the same plot; default
    is \code{cl2 = "red"} for higher order solutions, and 
    \code{cl1 = "blue"} for the remaining first order statistics.  
    The default color of the plot is \code{col = "black"}.
  }
  \item{ylim}{
    a numerical vector with two elements defining the \eqn{y}{y}-axis
    range; only if \code{x} is a \code{profile.nlreg} object.  
  }
  \item{\dots}{
   additional graphics parameters.
  }
}
\value{
  No value is returned.
}
\section{Side Effects}{
  A plot is produced on the current graphics device.
}
\references{
  Fraser, D.A.S., Reid, N. and Wu, J. (1999).  A simple general formula 
  for tail probabilities for frequentist and Bayesian inference. 
  \emph{Biometrika}, \bold{86}, 249--264.

  Skovgaard, I.  (1996) An explicit large-deviation approximation to
  one-parameter tests.  \emph{Bernoulli}, \bold{2}, 145--165.
}
\seealso{
  \code{\link[nlreg]{profile.nlreg}}, 
  \code{\link[nlreg]{nlreg.profile.objects}}, 
  \code{\link[graphics]{plot}}
}
\examples{
data(metsulfuron)
metsulfuron.nl <- nlreg( formula = log(area) ~ log( b1+(b2-b1) / (1+(dose/b4)^b3) ), 
                    weights = ~ ( 1+dose^exp(g) )^2, data = metsulfuron, 
                    start = c(b1 = 138, b2 = 2470, b3 = 2, b4 = 0.07, g = log(0.3)),
                    hoa = TRUE)
##
metsulfuron.prof <- profile( metsulfuron.nl, offset = g, trace = TRUE )
plot( metsulfuron.prof, lwd2 = 2 )
##
metsulfuron.prof <- profile( metsulfuron.nl, trace = TRUE )
plot( metsulfuron.prof, lwd2 = 2, nframe = c(2,3) )
}
\keyword{methods}
\keyword{regression}
\keyword{hplot}
