% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_game_ids.R
\name{get_game_ids}
\alias{get_game_ids}
\title{Fetch game IDs for a single day or a full season}
\usage{
get_game_ids(season = NULL, day = as.Date(Sys.Date(), "\%Y-\%m-\%d"))
}
\arguments{
\item{season}{An integer value denoting the end year of the season to scrape}

\item{day}{A day in the format of 'YYYY-MM-DD'}
}
\value{
A tibble containing game IDs for specified time frame
}
\description{
Fetch game IDs for a single day or a full season
}
\examples{
\dontrun{
get_game_ids(season = 2020)
get_game_ids(day = "2015-03-12")
}
}
