% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_zs_holland.R
\name{con_zs_holland}
\alias{con_zs_holland}
\title{Congruence Index according to Zener & Schnuelle (1976)}
\usage{
con_zs_holland(a, b)
}
\arguments{
\item{a}{a character vector with person Holland codes.}

\item{b}{a character vector with environment Holland codes.}
}
\value{
a numeric with value for congruence.
}
\description{
The function computes the congruence index according to Zener & Schnuelle (1976).
}
\details{
The function finds the congruence according to Zener & Schnuelle (1976) between the three-letter Holland-codes given in argument a, which is the person code, and argument b, which is the environment code. The Index as defined by Zener & Schnuelle (1976) targets (only) three letters from the Holland code. The degree of congruence is output, according to its definition by Zener & Schnuelle (1976), as a reciprocal value of a distance. This means, for example, that a value of '6' is the result for a perfect fit of two three-letter codes !
}
\examples{
con_zs_holland(a="RIA",b="SEC") # max. difference 
con_zs_holland(a="RIA",b="RIA") # max. similarity
}
\references{
Holland, J.L. 1963. A theory of vocational choice. I. Vocational images and choice. \emph{Vocational Guidance Quarterly, 11}(4), 232–239.

Zener, T. B. & Schnuelle, L. (1976). Effects of the self-directed search on high school students. \emph{Journal of Counseling Psychology, 23}(4), 353–359.
}
\keyword{congruence}
