% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_sensor.R
\name{d_sensor}
\alias{d_sensor}
\title{Create, Modify or Remove a sensor}
\usage{
d_sensor(
  fsq,
  op = "C",
  sta,
  sen,
  table,
  name_fld = NA,
  value_fld = NA,
  bku = TRUE
)
}
\arguments{
\item{fsq}{Full name of the data base}

\item{op}{Create (default), modify or remove C/M/R}

\item{sta}{Station id}

\item{sen}{Sensor id}

\item{table}{Table of the sensor}

\item{name_fld}{List of field names}

\item{value_fld}{List of field values}

\item{bku}{Automatic Backup TRUE (default) / FALSE}
}
\value{
Sensor created, modified or removed from the data base
}
\description{
Create, Modify or Remove a sensor. A shiny version of this function
is available: \code{link{ds_sensor}}
}
\details{
If op is C, the fields sta, table and sen are compulsory and cannot be modified afterwards.

Allowed entries for table are: WL (water levels), DI (discharges),
QU (Quality), PR (precipitations), WE (weather).

The field names are expressed in French for compatibility reason with Hydraccess.
A translation is given in [].

If op is C or M, the following fields can be completed :
\itemize{
\item [Nature] Nature= as.character(NA),
\item [Description] Description = as.character(NA),
\item [Comment] Commentaire= as.character(NA),
\item [Limni id] Code_Limni= as.character(NA),
\item [Principal] Principal = as.logical(NA),
\item [Fictive] Fictif = as.logical(NA),
\item [Daily update] Maj_Journaliers = as.logical(NA),
\item [Translation update] Maj_Traduction = as.logical(NA),
\item [Automatic acquisition] Acquisition_Auto = as.logical(NA),
\item [Operationnal] Operationnel = as.logical(NA),
\item [Instantaneous list] Liste_Inst = as.character(NA),
\item [Daily list] Liste_Jour = as.character(NA),
\item [Monthly list] Liste_Mois = as.character(NA),
\item [Aggregation] Agregation = as.character(NA),
\item [Time shift] Decalage_Temps = as.numeric(NA),
\item [Min] Mini = as.numeric(NA),
\item [Max] Maxi = as.numeric(NA),
\item [Gradient] Gradient_Maxi = as.numeric(NA),
\item [Accuracy] Precision = as.numeric(NA),
\item [Decimals] Decimales = as.numeric(NA),
\item [Slope] Pente = as.numeric(NA))
}

If op is R, all data corresponding to the sensor of the selected
station are removed.
}
\seealso{
\itemize{
 \item \code{\link{d_inventory}} or \code{\link{ds_inventory}} to explore the
 data base content;
 \item \code{\link{ds_exp_hts}} to extract a time-series;
 \item \code{\link{d_create}, \link{d_table}} to create a data base and/or create/remove
 a table ;
 \item \code{\link{d_station}} or \code{\link{ds_station}}for create/remove a station.
}
}
\author{
P. Chevallier - Feb 2018-Dec 2022
}
