% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_draw_smooth.R
\name{age_draw_smooth}
\alias{age_draw_smooth}
\title{Draws ages from a smoothed distribution for a given gender/race combination}
\usage{
age_draw_smooth(g, r, nsamp, agelim_months)
}
\arguments{
\item{g}{Gender. Either 'Male' or 'Female'.}

\item{r}{Race/ethnicity. One of 'Mexican American', 'Other Hispanic', 
'Non-Hispanic Black', 'Non-Hispanic White', 'Other'.}

\item{nsamp}{Number of ages to draw.}

\item{agelim_months}{Two-element numeric vector giving the minimum and 
maximum ages in months to include.}
}
\value{
A named list with members 'ages_months' and 'ages_years', each 
  numeric of length \code{nsamp}, giving the sampled ages in months and 
  years.
}
\description{
Draws ages from a smoothed distribution for a given gender/race combination
}

