% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_mass_functions.R
\name{skeletal_muscle_mass}
\alias{skeletal_muscle_mass}
\title{Predict skeletal muscle mass}
\usage{
skeletal_muscle_mass(smm, age_years, height, gender)
}
\arguments{
\item{smm}{Vector of allometrically-scaled skeletal muscle masses.}

\item{age_years}{Vector of ages in years.}

\item{height}{Vector of heights in cm.}

\item{gender}{Vector of genders, either 'Male' or 'Female.'}
}
\value{
Vector of skeletal muscle masses in kg.
}
\description{
Predict skeletal muscle mass from age, height, and gender.
}
\details{
For individuals over age 18, use allometrically-scaled muscle mass with an
age-based scaling factor, to account for loss of muscle mass with age
(Janssen et al. 2000). For individuals under age 18, use
\code{\link{skeletal_muscle_mass_children}}.
}
\references{
Janssen, Ian, et al. "Skeletal muscle mass and distribution in 468 men and
women aged 18-88 yer." Journal of Applied Physiology 89.1 (2000): 81-88

\insertRef{ring2017identifying}{httk}
}
\seealso{
\code{\link{skeletal_muscle_mass_children}}
}
\author{
Caroline Ring
}
\keyword{httk-pop}
