% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hudr.R
\name{get_hud_il_data}
\alias{get_hud_il_data}
\title{Get HUD Income Limit data at the County or MSA Level from HUD.}
\usage{
get_hud_il_data(entityid = "0100199999", yr, hud_key)
}
\arguments{
\item{entityid}{Character string containing the 'fips_code' from get_hud_fmr_listcounties(...) or 'cbsa_code' from get_hud_fmr_listmetros(...).}

\item{yr}{Character string indicating the year.}

\item{hud_key}{Character string indicating your API key from HUD.}
}
\value{
A list of data tables containing income limit data from HUD.
}
\description{
Provides income limit data at the County and MSA level from HUD.
}
\details{
Provides income limit data at the County and MSA level from HUD.
}
\examples{
\dontrun{
library(hudr)

hud_key <- Sys.getenv("HUD_API_KEY")

cbsa_codes <- get_hud_fmr_listmetros(hud_key = hud_key)
cnty_codes <- get_hud_fmr_listcounties(hud_key = hud_key)

il_msa_dt <- get_hud_il_data(entityid = cbsa_codes$cbsa_code[1],
                             yr = "2020",
                             hud_key = hud_key)
il_cnty_dt <- get_hud_il_data(entityid = cnty_codes$fips_code[1],
                              yr = "2020",
                              hud_key = hud_key)
}
}
\author{
Paul Richardson
}
